/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.log4j.aws.internal.sns;

import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.AmazonSNSClient;
import com.amazonaws.services.sns.model.CreateTopicResult;
import com.amazonaws.services.sns.model.ListTopicsRequest;
import com.amazonaws.services.sns.model.ListTopicsResult;
import com.amazonaws.services.sns.model.PublishRequest;
import com.amazonaws.services.sns.model.Topic;
import com.kdgregory.log4j.aws.internal.shared.AbstractLogWriter;
import com.kdgregory.log4j.aws.internal.shared.LogMessage;
import com.kdgregory.log4j.aws.internal.sns.SNSAppenderStatistics;
import com.kdgregory.log4j.aws.internal.sns.SNSWriterConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.log4j.helpers.LogLog;

public class SNSLogWriter
extends AbstractLogWriter {
    protected SNSWriterConfig config;
    private SNSAppenderStatistics stats;
    protected AmazonSNS client;
    protected String topicArn;

    public SNSLogWriter(SNSWriterConfig config, SNSAppenderStatistics stats) {
        super(stats, 1L, config.discardThreshold, config.discardAction);
        this.config = config;
        this.stats = stats;
    }

    @Override
    protected void createAWSClient() {
        this.client = this.tryClientFactory(this.config.clientFactoryMethod, AmazonSNS.class, true);
        if (this.client == null && this.config.clientEndpoint == null) {
            this.client = this.tryClientFactory("com.amazonaws.services.sns.AmazonSNSClientBuilder.defaultClient", AmazonSNS.class, false);
        }
        if (this.client == null) {
            LogLog.debug((String)(this.getClass().getSimpleName() + ": creating service client via constructor"));
            this.client = (AmazonSNS)this.tryConfigureEndpointOrRegion(new AmazonSNSClient(), this.config.clientEndpoint);
        }
    }

    @Override
    protected boolean ensureDestinationAvailable() {
        try {
            boolean topicAvailable;
            boolean bl = topicAvailable = this.config.topicArn != null ? this.configureByArn() : this.configureByName();
            if (topicAvailable) {
                this.stats.setActualTopicArn(this.topicArn);
                this.stats.setActualTopicName(this.topicArn.replaceAll(".*:", ""));
            }
            return topicAvailable;
        }
        catch (Exception ex) {
            return this.initializationFailure("exception in initializer", ex);
        }
    }

    @Override
    protected List<LogMessage> processBatch(List<LogMessage> currentBatch) {
        ArrayList<LogMessage> failures = new ArrayList<LogMessage>();
        for (LogMessage message : currentBatch) {
            try {
                PublishRequest request = new PublishRequest().withTopicArn(this.topicArn).withMessage(message.getMessage());
                if (this.config.subject != null) {
                    request.setSubject(this.config.subject);
                }
                this.client.publish(request);
            }
            catch (Exception ex) {
                this.stats.setLastError(null, ex);
                LogLog.error((String)"failed to send message", (Throwable)ex);
                failures.add(message);
            }
        }
        this.stats.updateMessagesSent(currentBatch.size() - failures.size());
        return failures;
    }

    @Override
    protected int effectiveSize(LogMessage message) {
        return message.size();
    }

    @Override
    protected boolean withinServiceLimits(int batchBytes, int numMessages) {
        return batchBytes <= 262144 && numMessages <= 1;
    }

    private boolean configureByArn() {
        if (this.retrieveAllTopics().contains(this.config.topicArn)) {
            this.topicArn = this.config.topicArn;
            return true;
        }
        return this.initializationFailure("unable to find specified topicArn: " + this.config.topicArn, null);
    }

    private boolean configureByName() {
        String topicName = this.config.topicName;
        if (!Pattern.matches("[A-Za-z0-9_-]{1,256}", this.config.topicName)) {
            return this.initializationFailure("invalid topic name: " + topicName, null);
        }
        this.topicArn = this.retrieveAllTopicsByName().get(this.config.topicName);
        if (this.topicArn != null) {
            LogLog.debug((String)("using existing SNS topic: " + topicName));
            return true;
        }
        if (this.config.autoCreate) {
            LogLog.debug((String)("creating SNS topic: " + topicName));
            CreateTopicResult response = this.client.createTopic(topicName);
            this.topicArn = response.getTopicArn();
            return true;
        }
        LogLog.error((String)("topic does not exist and auto-create not enabled: " + topicName));
        this.stats.setLastError("topic does not exist: " + topicName, null);
        return false;
    }

    private Set<String> retrieveAllTopics() {
        HashSet<String> result = new HashSet<String>();
        ListTopicsRequest request = new ListTopicsRequest();
        ListTopicsResult response = null;
        do {
            response = this.client.listTopics(request);
            for (Topic topic : response.getTopics()) {
                result.add(topic.getTopicArn());
            }
            request.setNextToken(response.getNextToken());
        } while (response.getNextToken() != null);
        return result;
    }

    private Map<String, String> retrieveAllTopicsByName() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String arn : this.retrieveAllTopics()) {
            String topicName = arn.replaceFirst(".*:", "");
            result.put(topicName, arn);
        }
        return result;
    }
}

