/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.aws.facade.v1;

import com.amazonaws.services.logs.AWSLogs;
import com.amazonaws.services.logs.model.AWSLogsException;
import com.amazonaws.services.logs.model.CreateLogGroupRequest;
import com.amazonaws.services.logs.model.CreateLogStreamRequest;
import com.amazonaws.services.logs.model.DataAlreadyAcceptedException;
import com.amazonaws.services.logs.model.DescribeLogGroupsRequest;
import com.amazonaws.services.logs.model.DescribeLogGroupsResult;
import com.amazonaws.services.logs.model.DescribeLogStreamsRequest;
import com.amazonaws.services.logs.model.DescribeLogStreamsResult;
import com.amazonaws.services.logs.model.InputLogEvent;
import com.amazonaws.services.logs.model.InvalidParameterException;
import com.amazonaws.services.logs.model.InvalidSequenceTokenException;
import com.amazonaws.services.logs.model.LogGroup;
import com.amazonaws.services.logs.model.LogStream;
import com.amazonaws.services.logs.model.OperationAbortedException;
import com.amazonaws.services.logs.model.PutLogEventsRequest;
import com.amazonaws.services.logs.model.PutLogEventsResult;
import com.amazonaws.services.logs.model.PutRetentionPolicyRequest;
import com.amazonaws.services.logs.model.ResourceAlreadyExistsException;
import com.amazonaws.services.logs.model.ResourceNotFoundException;
import com.kdgregory.logging.aws.cloudwatch.CloudWatchWriterConfig;
import com.kdgregory.logging.aws.facade.CloudWatchFacade;
import com.kdgregory.logging.aws.facade.CloudWatchFacadeException;
import com.kdgregory.logging.aws.facade.v1.internal.ClientFactory;
import com.kdgregory.logging.aws.internal.AbstractWriterConfig;
import com.kdgregory.logging.common.LogMessage;
import java.util.List;
import java.util.stream.Collectors;

public class CloudWatchFacadeImpl
implements CloudWatchFacade {
    private CloudWatchWriterConfig config;
    protected AWSLogs client;

    public CloudWatchFacadeImpl(CloudWatchWriterConfig config) {
        this.config = config;
    }

    public String findLogGroup() {
        String logGroupName = this.config.getLogGroupName();
        try {
            DescribeLogGroupsResult result;
            DescribeLogGroupsRequest request = new DescribeLogGroupsRequest().withLogGroupNamePrefix(logGroupName);
            do {
                result = this.client().describeLogGroups(request);
                for (LogGroup group : result.getLogGroups()) {
                    if (!group.getLogGroupName().equals(logGroupName)) continue;
                    return group.getArn();
                }
                request.setNextToken(result.getNextToken());
            } while (result.getNextToken() != null);
            return null;
        }
        catch (Exception ex) {
            CloudWatchFacadeException ex2 = this.transformException("findLogGroup", ex);
            if (ex2.isRetryable()) {
                return null;
            }
            throw ex2;
        }
    }

    public void createLogGroup() {
        String logGroupName = this.config.getLogGroupName();
        try {
            CreateLogGroupRequest request = new CreateLogGroupRequest().withLogGroupName(logGroupName);
            this.client().createLogGroup(request);
            return;
        }
        catch (ResourceAlreadyExistsException ex) {
            return;
        }
        catch (Exception ex) {
            throw this.transformException("createLogGroup", ex);
        }
    }

    public void setLogGroupRetention() {
        if (this.config.getRetentionPeriod() == null) {
            return;
        }
        try {
            this.client().putRetentionPolicy(new PutRetentionPolicyRequest(this.config.getLogGroupName(), this.config.getRetentionPeriod()));
        }
        catch (InvalidParameterException ex) {
            throw new CloudWatchFacadeException("invalid retention period: " + this.config.getRetentionPeriod(), CloudWatchFacadeException.ReasonCode.INVALID_CONFIGURATION, false, "setLogGroupRetention", new Object[]{this.config.getLogGroupName()});
        }
        catch (Exception ex) {
            throw this.transformException("setLogGroupRetention", ex);
        }
    }

    public void createLogStream() {
        String logGroupName = this.config.getLogGroupName();
        String logStreamName = this.config.getLogStreamName();
        try {
            CreateLogStreamRequest request = new CreateLogStreamRequest().withLogGroupName(logGroupName).withLogStreamName(logStreamName);
            this.client().createLogStream(request);
            return;
        }
        catch (ResourceAlreadyExistsException ex) {
            return;
        }
        catch (ResourceNotFoundException ex) {
            throw new CloudWatchFacadeException("log group missing", CloudWatchFacadeException.ReasonCode.MISSING_LOG_GROUP, false, "createLogStream", new Object[]{this.config.getLogGroupName()});
        }
        catch (Exception ex) {
            throw this.transformException("createLogStream", ex);
        }
    }

    public String retrieveSequenceToken() {
        String logGroupName = this.config.getLogGroupName();
        String logStreamName = this.config.getLogStreamName();
        DescribeLogStreamsRequest request = new DescribeLogStreamsRequest(logGroupName).withLogStreamNamePrefix(logStreamName);
        try {
            DescribeLogStreamsResult result;
            do {
                result = this.client().describeLogStreams(request);
                for (LogStream stream : result.getLogStreams()) {
                    if (!stream.getLogStreamName().equals(this.config.getLogStreamName())) continue;
                    return stream.getUploadSequenceToken();
                }
                request.setNextToken(result.getNextToken());
            } while (result.getNextToken() != null);
        }
        catch (ResourceNotFoundException ex) {
            return null;
        }
        catch (Exception ex) {
            CloudWatchFacadeException ex2 = this.transformException("retrieveSequenceToken()", ex);
            if (ex2.isRetryable()) {
                return null;
            }
            throw ex2;
        }
        return null;
    }

    public String putEvents(String sequenceToken, List<LogMessage> messages) {
        if (messages.isEmpty()) {
            return sequenceToken;
        }
        List events = messages.stream().map(m -> new InputLogEvent().withTimestamp(Long.valueOf(m.getTimestamp())).withMessage(m.getMessage())).collect(Collectors.toList());
        PutLogEventsRequest request = new PutLogEventsRequest().withLogGroupName(this.config.getLogGroupName()).withLogStreamName(this.config.getLogStreamName()).withSequenceToken(sequenceToken).withLogEvents(events);
        try {
            PutLogEventsResult response = this.client().putLogEvents(request);
            return response.getNextSequenceToken();
        }
        catch (InvalidSequenceTokenException ex) {
            throw new CloudWatchFacadeException("invalid sequence token: " + sequenceToken, CloudWatchFacadeException.ReasonCode.INVALID_SEQUENCE_TOKEN, false, "putEvents", new Object[]{this.config.getLogGroupName(), this.config.getLogStreamName()});
        }
        catch (ResourceNotFoundException ex) {
            throw new CloudWatchFacadeException("missing log group", CloudWatchFacadeException.ReasonCode.MISSING_LOG_GROUP, false, "putEvents", new Object[]{this.config.getLogGroupName(), this.config.getLogStreamName()});
        }
        catch (DataAlreadyAcceptedException ex) {
            throw new CloudWatchFacadeException("already processed", CloudWatchFacadeException.ReasonCode.ALREADY_PROCESSED, false, "putEvents", new Object[]{this.config.getLogGroupName(), this.config.getLogStreamName()});
        }
        catch (Exception ex) {
            throw this.transformException("putEvents", ex);
        }
    }

    public void shutdown() {
        this.client().shutdown();
    }

    protected AWSLogs client() {
        if (this.client == null) {
            this.client = new ClientFactory<AWSLogs>(AWSLogs.class, (AbstractWriterConfig<?>)this.config).create();
        }
        return this.client;
    }

    private CloudWatchFacadeException transformException(String functionName, Exception cause) {
        boolean isRetryable;
        String message;
        CloudWatchFacadeException.ReasonCode reason;
        if (cause == null) {
            reason = CloudWatchFacadeException.ReasonCode.UNEXPECTED_EXCEPTION;
            message = "coding error; exception not provided";
            isRetryable = false;
        } else if (cause instanceof OperationAbortedException) {
            reason = CloudWatchFacadeException.ReasonCode.ABORTED;
            message = "request aborted";
            isRetryable = true;
        } else if (cause instanceof AWSLogsException) {
            AWSLogsException ex = (AWSLogsException)cause;
            if ("ThrottlingException".equals(ex.getErrorCode())) {
                reason = CloudWatchFacadeException.ReasonCode.THROTTLING;
                message = "request throttled";
                isRetryable = true;
            } else {
                reason = CloudWatchFacadeException.ReasonCode.UNEXPECTED_EXCEPTION;
                message = "service exception: " + cause.getMessage();
                isRetryable = false;
            }
        } else {
            reason = CloudWatchFacadeException.ReasonCode.UNEXPECTED_EXCEPTION;
            message = "unexpected exception: " + cause.getMessage();
            isRetryable = false;
        }
        return new CloudWatchFacadeException(message, (Throwable)cause, reason, isRetryable, functionName, new Object[]{this.config.getLogGroupName(), this.config.getLogStreamName()});
    }
}

