/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.aws.facade.v1;

import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.model.CreateStreamRequest;
import com.amazonaws.services.kinesis.model.DescribeStreamSummaryRequest;
import com.amazonaws.services.kinesis.model.DescribeStreamSummaryResult;
import com.amazonaws.services.kinesis.model.IncreaseStreamRetentionPeriodRequest;
import com.amazonaws.services.kinesis.model.LimitExceededException;
import com.amazonaws.services.kinesis.model.ProvisionedThroughputExceededException;
import com.amazonaws.services.kinesis.model.PutRecordsRequest;
import com.amazonaws.services.kinesis.model.PutRecordsRequestEntry;
import com.amazonaws.services.kinesis.model.PutRecordsResult;
import com.amazonaws.services.kinesis.model.PutRecordsResultEntry;
import com.amazonaws.services.kinesis.model.ResourceInUseException;
import com.amazonaws.services.kinesis.model.ResourceNotFoundException;
import com.kdgregory.logging.aws.facade.KinesisFacade;
import com.kdgregory.logging.aws.facade.KinesisFacadeException;
import com.kdgregory.logging.aws.facade.v1.internal.ClientFactory;
import com.kdgregory.logging.aws.internal.AbstractWriterConfig;
import com.kdgregory.logging.aws.kinesis.KinesisConstants;
import com.kdgregory.logging.aws.kinesis.KinesisWriterConfig;
import com.kdgregory.logging.common.LogMessage;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class KinesisFacadeImpl
implements KinesisFacade {
    private static final Map<String, KinesisConstants.StreamStatus> STATUS_LOOKUP = new HashMap<String, KinesisConstants.StreamStatus>();
    private KinesisWriterConfig config;
    private AmazonKinesis client;

    public KinesisFacadeImpl(KinesisWriterConfig config) {
        this.config = config;
    }

    public KinesisConstants.StreamStatus retrieveStreamStatus() {
        try {
            DescribeStreamSummaryRequest request = new DescribeStreamSummaryRequest().withStreamName(this.config.getStreamName());
            DescribeStreamSummaryResult response = this.client().describeStreamSummary(request);
            return STATUS_LOOKUP.get(response.getStreamDescriptionSummary().getStreamStatus());
        }
        catch (ResourceNotFoundException ex) {
            return KinesisConstants.StreamStatus.DOES_NOT_EXIST;
        }
        catch (LimitExceededException ex) {
            return null;
        }
        catch (Exception ex) {
            throw this.transformException("retrieveStreamStatus", ex);
        }
    }

    public void createStream() {
        try {
            CreateStreamRequest request = new CreateStreamRequest().withStreamName(this.config.getStreamName()).withShardCount(Integer.valueOf(this.config.getShardCount()));
            this.client().createStream(request);
        }
        catch (ResourceInUseException ex) {
            return;
        }
        catch (Exception ex) {
            throw this.transformException("createStream", ex);
        }
    }

    public void setRetentionPeriod() {
        if (this.config.getRetentionPeriod() == null) {
            return;
        }
        try {
            IncreaseStreamRetentionPeriodRequest request = new IncreaseStreamRetentionPeriodRequest().withStreamName(this.config.getStreamName()).withRetentionPeriodHours(this.config.getRetentionPeriod());
            this.client().increaseStreamRetentionPeriod(request);
        }
        catch (Exception ex) {
            throw this.transformException("setRetentionPeriod", ex);
        }
    }

    public List<LogMessage> putRecords(List<LogMessage> batch) {
        if (batch.isEmpty()) {
            return batch;
        }
        try {
            PutRecordsRequest request = this.createPutRecordsRequest(batch);
            PutRecordsResult response = this.client().putRecords(request);
            return this.extractPutRecordsFailures(batch, response);
        }
        catch (Exception ex) {
            throw this.transformException("putRecords", ex);
        }
    }

    public void shutdown() {
        this.client().shutdown();
    }

    protected AmazonKinesis client() {
        if (this.client == null) {
            this.client = new ClientFactory<AmazonKinesis>(AmazonKinesis.class, (AbstractWriterConfig<?>)this.config).create();
        }
        return this.client;
    }

    private KinesisFacadeException transformException(String functionName, Exception ex) {
        boolean isRetryable;
        KinesisFacadeException.ReasonCode reason;
        String message;
        if (ex instanceof ProvisionedThroughputExceededException) {
            message = "throttled";
            reason = KinesisFacadeException.ReasonCode.THROTTLING;
            isRetryable = true;
        } else if (ex instanceof LimitExceededException) {
            message = "limit exceeded";
            reason = KinesisFacadeException.ReasonCode.LIMIT_EXCEEDED;
            isRetryable = true;
        } else if (ex instanceof ResourceInUseException) {
            message = "stream not active";
            reason = KinesisFacadeException.ReasonCode.INVALID_STATE;
            isRetryable = true;
        } else {
            message = "unexpected exception: " + ex.getMessage();
            reason = KinesisFacadeException.ReasonCode.UNEXPECTED_EXCEPTION;
            isRetryable = false;
        }
        return new KinesisFacadeException(message, (Throwable)ex, reason, isRetryable, functionName, new Object[]{this.config.getStreamName()});
    }

    private PutRecordsRequest createPutRecordsRequest(List<LogMessage> batch) {
        ArrayList<PutRecordsRequestEntry> requestRecords = new ArrayList<PutRecordsRequestEntry>(batch.size());
        for (LogMessage message : batch) {
            requestRecords.add(new PutRecordsRequestEntry().withPartitionKey(this.config.getPartitionKeyHelper().getValue()).withData(ByteBuffer.wrap(message.getBytes())));
        }
        return new PutRecordsRequest().withStreamName(this.config.getStreamName()).withRecords(requestRecords);
    }

    private List<LogMessage> extractPutRecordsFailures(List<LogMessage> batch, PutRecordsResult response) {
        ArrayList<LogMessage> result = new ArrayList<LogMessage>(batch.size());
        if (response.getFailedRecordCount() == null || response.getFailedRecordCount() == 0) {
            return result;
        }
        Iterator<LogMessage> lmItx = batch.iterator();
        Iterator rspItx = response.getRecords().iterator();
        while (lmItx.hasNext() && rspItx.hasNext()) {
            LogMessage logMessage = lmItx.next();
            PutRecordsResultEntry entry = (PutRecordsResultEntry)rspItx.next();
            if (entry.getErrorCode() == null || entry.getErrorCode().isEmpty()) continue;
            result.add(logMessage);
        }
        return result;
    }

    static {
        STATUS_LOOKUP.put("ACTIVE", KinesisConstants.StreamStatus.ACTIVE);
        STATUS_LOOKUP.put("CREATING", KinesisConstants.StreamStatus.CREATING);
        STATUS_LOOKUP.put("DELETING", KinesisConstants.StreamStatus.DELETING);
        STATUS_LOOKUP.put("UPDATING", KinesisConstants.StreamStatus.UPDATING);
    }
}

