/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.aws.facade.v1;

import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.model.AmazonSNSException;
import com.amazonaws.services.sns.model.CreateTopicRequest;
import com.amazonaws.services.sns.model.CreateTopicResult;
import com.amazonaws.services.sns.model.ListTopicsRequest;
import com.amazonaws.services.sns.model.ListTopicsResult;
import com.amazonaws.services.sns.model.NotFoundException;
import com.amazonaws.services.sns.model.PublishRequest;
import com.amazonaws.services.sns.model.Topic;
import com.kdgregory.logging.aws.facade.SNSFacade;
import com.kdgregory.logging.aws.facade.SNSFacadeException;
import com.kdgregory.logging.aws.facade.v1.internal.ClientFactory;
import com.kdgregory.logging.aws.internal.AbstractWriterConfig;
import com.kdgregory.logging.aws.sns.SNSWriterConfig;
import com.kdgregory.logging.common.LogMessage;

public class SNSFacadeImpl
implements SNSFacade {
    private SNSWriterConfig config;
    private AmazonSNS client;

    public SNSFacadeImpl(SNSWriterConfig config) {
        this.config = config;
    }

    public String lookupTopic() {
        String match = this.config.getTopicArn() != null ? this.config.getTopicArn() : ":" + this.config.getTopicName();
        try {
            ListTopicsRequest request = new ListTopicsRequest();
            do {
                ListTopicsResult response = this.client().listTopics(request);
                for (Topic topic : response.getTopics()) {
                    String arn = topic.getTopicArn();
                    if (!arn.endsWith(match)) continue;
                    return arn;
                }
                request.setNextToken(response.getNextToken());
            } while (request.getNextToken() != null && !request.getNextToken().isEmpty());
            return null;
        }
        catch (Exception ex) {
            throw this.transformException("lookupTopic", ex);
        }
    }

    public String createTopic() {
        try {
            CreateTopicRequest request = new CreateTopicRequest(this.config.getTopicName());
            CreateTopicResult response = this.client().createTopic(request);
            return response.getTopicArn();
        }
        catch (Exception ex) {
            throw this.transformException("createTopic", ex);
        }
    }

    public void publish(LogMessage message) {
        if (this.config.getTopicArn() == null || this.config.getTopicArn().isEmpty()) {
            throw new SNSFacadeException("ARN not configured", SNSFacadeException.ReasonCode.INVALID_CONFIGURATION, false, "publish", new Object[0]);
        }
        try {
            PublishRequest request = new PublishRequest().withTopicArn(this.config.getTopicArn()).withSubject(this.config.getSubject()).withMessage(message.getMessage());
            this.client().publish(request);
        }
        catch (Exception ex) {
            throw this.transformException("publish", ex);
        }
    }

    public void shutdown() {
        this.client().shutdown();
    }

    protected AmazonSNS client() {
        if (this.client == null) {
            this.client = new ClientFactory<AmazonSNS>(AmazonSNS.class, (AbstractWriterConfig<?>)this.config).create();
        }
        return this.client;
    }

    private SNSFacadeException transformException(String functionName, Exception cause) {
        boolean isRetryable;
        String message;
        SNSFacadeException.ReasonCode reason;
        if (cause instanceof NotFoundException) {
            reason = SNSFacadeException.ReasonCode.MISSING_TOPIC;
            message = "topic does not exist";
            isRetryable = false;
        } else if (cause instanceof AmazonSNSException) {
            AmazonSNSException ex = (AmazonSNSException)cause;
            if ("Throttling".equals(ex.getErrorCode())) {
                reason = SNSFacadeException.ReasonCode.THROTTLING;
                message = "request throttled";
                isRetryable = true;
            } else {
                reason = SNSFacadeException.ReasonCode.UNEXPECTED_EXCEPTION;
                message = "service exception: " + cause.getMessage();
                isRetryable = false;
            }
        } else {
            message = "unexpected exception: " + cause.getMessage();
            reason = SNSFacadeException.ReasonCode.UNEXPECTED_EXCEPTION;
            isRetryable = false;
        }
        return new SNSFacadeException(message, (Throwable)cause, reason, isRetryable, functionName, new Object[]{this.config.getTopicArn() != null ? this.config.getTopicArn() : this.config.getTopicName()});
    }
}

