/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.aws.facade.v1.internal;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.kinesis.AmazonKinesisClientBuilder;
import com.amazonaws.services.logs.AWSLogsClientBuilder;
import com.amazonaws.services.sns.AmazonSNSClientBuilder;
import com.kdgregory.logging.aws.cloudwatch.CloudWatchWriterConfig;
import com.kdgregory.logging.aws.facade.v1.internal.AssumedRoleCredentialsProviderProvider;
import com.kdgregory.logging.aws.internal.AbstractWriterConfig;
import com.kdgregory.logging.aws.kinesis.KinesisWriterConfig;
import com.kdgregory.logging.aws.sns.SNSWriterConfig;
import com.kdgregory.logging.common.internal.Utils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ClientFactory<T> {
    private Class<T> clientType;
    private AbstractWriterConfig<?> config;

    public ClientFactory(Class<T> clientType, AbstractWriterConfig<?> config) {
        this.clientType = clientType;
        this.config = config;
    }

    public T create() {
        T client = this.tryInstantiateFromFactory();
        if (client != null) {
            return client;
        }
        AwsClientBuilder<?, ?> builder = this.createClientBuilder();
        this.optSetRegionOrEndpoint(builder);
        String roleToAssume = this.config.getAssumedRole();
        if (roleToAssume != null && !roleToAssume.isEmpty()) {
            this.setAssumedRoleCredentialsProvider(builder, roleToAssume);
        }
        return this.clientType.cast(builder.build());
    }

    protected T tryInstantiateFromFactory() {
        Method factoryMethod;
        String fullyQualifiedMethodName = this.config.getClientFactoryMethod();
        if (fullyQualifiedMethodName == null || fullyQualifiedMethodName.isEmpty()) {
            return null;
        }
        try {
            factoryMethod = Utils.findFullyQualifiedMethod((String)fullyQualifiedMethodName, (Class[])new Class[0]);
        }
        catch (Exception ignored) {
            try {
                factoryMethod = Utils.findFullyQualifiedMethod((String)fullyQualifiedMethodName, (Class[])new Class[]{String.class, String.class, String.class});
            }
            catch (Exception ex) {
                throw new RuntimeException("invalid factory method: " + fullyQualifiedMethodName, ex);
            }
        }
        try {
            return factoryMethod.getParameterTypes().length == 0 ? this.clientType.cast(factoryMethod.invoke(null, new Object[0])) : this.clientType.cast(factoryMethod.invoke(null, this.config.getAssumedRole(), this.config.getClientRegion(), this.config.getClientEndpoint()));
        }
        catch (Throwable ex) {
            if (ex instanceof InvocationTargetException) {
                ex = ex.getCause();
            }
            throw new RuntimeException("exception invoking factory method: " + fullyQualifiedMethodName, ex);
        }
    }

    protected AwsClientBuilder<?, ?> createClientBuilder() {
        if (this.config instanceof CloudWatchWriterConfig) {
            return new AWSLogsClientBuilderBuilder().buildBuilder();
        }
        if (this.config instanceof KinesisWriterConfig) {
            return new AmazonKinesisClientBuilderBuilder().buildBuilder();
        }
        if (this.config instanceof SNSWriterConfig) {
            return new AmazonSNSClientBuilderBuilder().buildBuilder();
        }
        throw new RuntimeException("unsupported configuration type: " + this.config.getClass());
    }

    protected void optSetRegionOrEndpoint(AwsClientBuilder<?, ?> builder) {
        String region = this.config.getClientRegion();
        String endpoint = this.config.getClientEndpoint();
        if (endpoint != null && !endpoint.isEmpty()) {
            builder.setEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpoint, region));
        } else if (region != null && !region.isEmpty()) {
            builder.setRegion(region);
        }
    }

    protected void setAssumedRoleCredentialsProvider(AwsClientBuilder<?, ?> builder, String roleToAssume) {
        STSAssumeRoleSessionCredentialsProvider credentialsProvider = new AssumedRoleCredentialsProviderProvider().provideProvider(roleToAssume);
        builder.setCredentials((AWSCredentialsProvider)credentialsProvider);
    }

    private static class AmazonSNSClientBuilderBuilder {
        private AmazonSNSClientBuilderBuilder() {
        }

        public AwsClientBuilder<?, ?> buildBuilder() {
            return AmazonSNSClientBuilder.standard();
        }
    }

    private static class AmazonKinesisClientBuilderBuilder {
        private AmazonKinesisClientBuilderBuilder() {
        }

        public AwsClientBuilder<?, ?> buildBuilder() {
            return AmazonKinesisClientBuilder.standard();
        }
    }

    private static class AWSLogsClientBuilderBuilder {
        private AWSLogsClientBuilderBuilder() {
        }

        public AwsClientBuilder<?, ?> buildBuilder() {
            return AWSLogsClientBuilder.standard();
        }
    }
}

