/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.aws.facade.v1;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.regions.DefaultAwsRegionProviderChain;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2ClientBuilder;
import com.amazonaws.services.ec2.model.DescribeTagsRequest;
import com.amazonaws.services.ec2.model.DescribeTagsResult;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.TagDescription;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.securitytoken.model.GetCallerIdentityRequest;
import com.amazonaws.services.securitytoken.model.GetCallerIdentityResult;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagement;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagementClientBuilder;
import com.amazonaws.services.simplesystemsmanagement.model.GetParameterRequest;
import com.amazonaws.services.simplesystemsmanagement.model.GetParameterResult;
import com.amazonaws.services.simplesystemsmanagement.model.ParameterType;
import com.amazonaws.util.EC2MetadataUtils;
import com.kdgregory.logging.aws.facade.InfoFacade;
import com.kdgregory.logging.common.util.RetryManager2;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class InfoFacadeImpl
implements InfoFacade {
    protected Duration retrieveTagsTimeout = Duration.ofMillis(1000L);
    protected RetryManager2 retrieveTagsRetry = new RetryManager2("describeTags", Duration.ofMillis(50L));
    protected Duration getParameterTimeout = Duration.ofMillis(1000L);
    protected RetryManager2 getParameterRetry = new RetryManager2("getParameter", Duration.ofMillis(50L));
    private AmazonEC2 ec2Client;
    private AWSSecurityTokenService stsClient;
    private AWSSimpleSystemsManagement ssmClient;

    public String retrieveAccountId() {
        try {
            GetCallerIdentityRequest request = new GetCallerIdentityRequest();
            GetCallerIdentityResult response = this.stsClient().getCallerIdentity(request);
            return response.getAccount();
        }
        catch (Exception ignored) {
            return "unknown";
        }
    }

    public String retrieveDefaultRegion() {
        return new DefaultAwsRegionProviderChain().getRegion();
    }

    public String retrieveEC2InstanceId() {
        return EC2MetadataUtils.getInstanceId();
    }

    public String retrieveEC2Region() {
        return EC2MetadataUtils.getEC2InstanceRegion();
    }

    public Map<String, String> retrieveEC2Tags(String instanceId) {
        return (Map)this.retrieveTagsRetry.invoke(this.retrieveTagsTimeout, () -> {
            try {
                ArrayList<Filter> filters = new ArrayList<Filter>();
                filters.add(new Filter().withName("resource-type").withValues(new String[]{"instance"}));
                filters.add(new Filter().withName("resource-id").withValues(new String[]{instanceId}));
                DescribeTagsRequest request = new DescribeTagsRequest().withFilters(filters);
                DescribeTagsResult response = this.ec2Client().describeTags(request);
                HashMap<String, String> result = new HashMap<String, String>();
                for (TagDescription desc : response.getTags()) {
                    result.put(desc.getKey(), desc.getValue());
                }
                return result;
            }
            catch (AmazonServiceException ex) {
                if ("RequestLimitExceeded".equals(ex.getErrorCode())) {
                    return null;
                }
                return new HashMap();
            }
            catch (Exception ignored) {
                return new HashMap();
            }
        });
    }

    public String retrieveParameter(String parameterName) {
        try {
            GetParameterResult result = (GetParameterResult)this.getParameterRetry.invoke(this.getParameterTimeout, () -> {
                try {
                    GetParameterRequest request = new GetParameterRequest().withName(parameterName);
                    return this.ssmClient().getParameter(request);
                }
                catch (AmazonServiceException ex) {
                    if ("ThrottlingException".equals(ex.getErrorCode())) {
                        return null;
                    }
                    throw ex;
                }
            });
            return result.getParameter().getType().equals(ParameterType.SecureString.name()) ? null : result.getParameter().getValue();
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected AmazonEC2 ec2Client() {
        if (this.ec2Client == null) {
            this.ec2Client = AmazonEC2ClientBuilder.defaultClient();
        }
        return this.ec2Client;
    }

    protected AWSSecurityTokenService stsClient() {
        if (this.stsClient == null) {
            this.stsClient = AWSSecurityTokenServiceClientBuilder.defaultClient();
        }
        return this.stsClient;
    }

    protected AWSSimpleSystemsManagement ssmClient() {
        if (this.ssmClient == null) {
            this.ssmClient = AWSSimpleSystemsManagementClientBuilder.defaultClient();
        }
        return this.ssmClient;
    }
}

