/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.aws.facade.v1.internal;

import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagement;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagementClientBuilder;
import com.amazonaws.services.identitymanagement.model.ListRolesRequest;
import com.amazonaws.services.identitymanagement.model.ListRolesResult;
import com.amazonaws.services.identitymanagement.model.Role;
import java.util.regex.Pattern;

public class AssumedRoleCredentialsProviderProvider {
    private AmazonIdentityManagement iamClient;

    public STSAssumeRoleSessionCredentialsProvider provideProvider(String roleNameOrArn) {
        String roleArn = this.retrieveArn(roleNameOrArn);
        if (roleArn == null) {
            throw new RuntimeException("no such role: " + roleNameOrArn);
        }
        return new STSAssumeRoleSessionCredentialsProvider.Builder(roleArn, "com.kdgregory.logging.aws").build();
    }

    protected AmazonIdentityManagement iamClient() {
        if (this.iamClient == null) {
            this.iamClient = AmazonIdentityManagementClientBuilder.defaultClient();
        }
        return this.iamClient;
    }

    public String retrieveArn(String nameOrArn) {
        ListRolesResult response;
        if (Pattern.matches("arn:.*:iam::\\d{12}:role/.*", nameOrArn)) {
            return nameOrArn;
        }
        ListRolesRequest request = new ListRolesRequest();
        boolean isTruncated = false;
        do {
            response = this.iamClient().listRoles(request);
            for (Role role : response.getRoles()) {
                if (!role.getRoleName().equals(nameOrArn) && !role.getArn().equals(nameOrArn)) continue;
                return role.getArn();
            }
            request.setMarker(response.getMarker());
        } while (isTruncated = response.isTruncated() != null && response.isTruncated() != false);
        return null;
    }
}

