/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.aws.facade.v2;

import com.kdgregory.logging.aws.facade.SNSFacade;
import com.kdgregory.logging.aws.facade.SNSFacadeException;
import com.kdgregory.logging.aws.facade.v2.internal.ClientFactory;
import com.kdgregory.logging.aws.internal.AbstractWriterConfig;
import com.kdgregory.logging.aws.sns.SNSWriterConfig;
import com.kdgregory.logging.common.LogMessage;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sns.model.CreateTopicRequest;
import software.amazon.awssdk.services.sns.model.CreateTopicResponse;
import software.amazon.awssdk.services.sns.model.NotFoundException;
import software.amazon.awssdk.services.sns.model.PublishRequest;
import software.amazon.awssdk.services.sns.model.SnsException;
import software.amazon.awssdk.services.sns.model.Topic;

public class SNSFacadeImpl
implements SNSFacade {
    private SNSWriterConfig config;
    private SnsClient client;

    public SNSFacadeImpl(SNSWriterConfig config) {
        this.config = config;
    }

    public String lookupTopic() {
        String match = this.config.getTopicArn() != null ? this.config.getTopicArn() : ":" + this.config.getTopicName();
        try {
            for (Topic topic : this.client().listTopicsPaginator().topics()) {
                String arn = topic.topicArn();
                if (!arn.endsWith(match)) continue;
                return arn;
            }
            return null;
        }
        catch (Exception ex) {
            throw this.transformException("lookupTopic", ex);
        }
    }

    public String createTopic() {
        try {
            CreateTopicRequest request = (CreateTopicRequest)CreateTopicRequest.builder().name(this.config.getTopicName()).build();
            CreateTopicResponse response = this.client().createTopic(request);
            return response.topicArn();
        }
        catch (Exception ex) {
            throw this.transformException("createTopic", ex);
        }
    }

    public void publish(LogMessage message) {
        if (this.config.getTopicArn() == null || this.config.getTopicArn().isEmpty()) {
            throw new SNSFacadeException("ARN not configured", SNSFacadeException.ReasonCode.INVALID_CONFIGURATION, false, "publish", new Object[0]);
        }
        try {
            PublishRequest request = (PublishRequest)PublishRequest.builder().topicArn(this.config.getTopicArn()).subject(this.config.getSubject()).message(message.getMessage()).build();
            this.client().publish(request);
        }
        catch (Exception ex) {
            throw this.transformException("publish", ex);
        }
    }

    public void shutdown() {
        this.client().close();
    }

    protected SnsClient client() {
        if (this.client == null) {
            this.client = new ClientFactory<SnsClient>(SnsClient.class, (AbstractWriterConfig<?>)this.config).create();
        }
        return this.client;
    }

    private SNSFacadeException transformException(String functionName, Exception cause) {
        boolean isRetryable;
        String message;
        SNSFacadeException.ReasonCode reason;
        if (cause instanceof NotFoundException) {
            reason = SNSFacadeException.ReasonCode.MISSING_TOPIC;
            message = "topic does not exist";
            isRetryable = false;
        } else if (cause instanceof SnsException) {
            String errorCode;
            SnsException ex = (SnsException)cause;
            String string = errorCode = ex.awsErrorDetails() != null ? ex.awsErrorDetails().errorCode() : null;
            if ("Throttling".equals(errorCode)) {
                reason = SNSFacadeException.ReasonCode.THROTTLING;
                message = "request throttled";
                isRetryable = true;
            } else {
                reason = SNSFacadeException.ReasonCode.UNEXPECTED_EXCEPTION;
                message = "service exception: " + cause.getMessage();
                isRetryable = false;
            }
        } else {
            message = "unexpected exception: " + cause.getMessage();
            reason = SNSFacadeException.ReasonCode.UNEXPECTED_EXCEPTION;
            isRetryable = false;
        }
        return new SNSFacadeException(message, (Throwable)cause, reason, isRetryable, functionName, new Object[]{this.config.getTopicArn() != null ? this.config.getTopicArn() : this.config.getTopicName()});
    }
}

