/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.aws.facade.v2;

import com.kdgregory.logging.aws.facade.InfoFacade;
import com.kdgregory.logging.common.util.RetryManager2;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.regions.internal.util.EC2MetadataUtils;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeTagsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTagsResponse;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.TagDescription;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.model.GetParameterRequest;
import software.amazon.awssdk.services.ssm.model.GetParameterResponse;
import software.amazon.awssdk.services.ssm.model.ParameterType;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.model.GetCallerIdentityRequest;
import software.amazon.awssdk.services.sts.model.GetCallerIdentityResponse;

public class InfoFacadeImpl
implements InfoFacade {
    private Ec2Client ec2Client;
    private StsClient stsClient;
    private SsmClient ssmClient;
    protected Duration retrieveTagsTimeout = Duration.ofMillis(1000L);
    protected RetryManager2 retrieveTagsRetry = new RetryManager2("describeTags", Duration.ofMillis(50L));
    protected Duration getParameterTimeout = Duration.ofMillis(1000L);
    protected RetryManager2 getParameterRetry = new RetryManager2("getParameter", Duration.ofMillis(50L));

    public String retrieveAccountId() {
        try {
            GetCallerIdentityRequest request = (GetCallerIdentityRequest)GetCallerIdentityRequest.builder().build();
            GetCallerIdentityResponse response = this.stsClient().getCallerIdentity(request);
            return response.account();
        }
        catch (Exception ignored) {
            return "unknown";
        }
    }

    public String retrieveDefaultRegion() {
        return new DefaultAwsRegionProviderChain().getRegion().id();
    }

    public String retrieveEC2InstanceId() {
        return EC2MetadataUtils.getInstanceId();
    }

    public String retrieveEC2Region() {
        return EC2MetadataUtils.getEC2InstanceRegion();
    }

    public Map<String, String> retrieveEC2Tags(String instanceId) {
        return (Map)this.retrieveTagsRetry.invoke(this.retrieveTagsTimeout, () -> {
            try {
                ArrayList<Object> filters = new ArrayList<Object>();
                filters.add(Filter.builder().name("resource-type").values(new String[]{"instance"}).build());
                filters.add(Filter.builder().name("resource-id").values(new String[]{instanceId}).build());
                DescribeTagsRequest request = (DescribeTagsRequest)DescribeTagsRequest.builder().filters(filters).build();
                DescribeTagsResponse response = this.ec2Client().describeTags(request);
                HashMap<String, String> result = new HashMap<String, String>();
                for (TagDescription desc : response.tags()) {
                    result.put(desc.key(), desc.value());
                }
                return result;
            }
            catch (AwsServiceException ex) {
                if ("RequestLimitExceeded".equals(ex.awsErrorDetails().errorCode())) {
                    return null;
                }
                return new HashMap();
            }
            catch (Exception ignored) {
                return new HashMap();
            }
        });
    }

    public String retrieveParameter(String parameterName) {
        try {
            GetParameterResponse result = (GetParameterResponse)this.getParameterRetry.invoke(this.getParameterTimeout, () -> {
                try {
                    GetParameterRequest request = (GetParameterRequest)GetParameterRequest.builder().name(parameterName).build();
                    return this.ssmClient().getParameter(request);
                }
                catch (AwsServiceException ex) {
                    AwsErrorDetails errorDetails = ex.awsErrorDetails();
                    if (errorDetails != null && "ThrottlingException".equals(errorDetails.errorCode())) {
                        return null;
                    }
                    throw ex;
                }
            });
            return result.parameter().type() == ParameterType.SECURE_STRING ? null : result.parameter().value();
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected Ec2Client ec2Client() {
        if (this.ec2Client == null) {
            this.ec2Client = (Ec2Client)Ec2Client.builder().build();
        }
        return this.ec2Client;
    }

    protected StsClient stsClient() {
        if (this.stsClient == null) {
            this.stsClient = (StsClient)StsClient.builder().build();
        }
        return this.stsClient;
    }

    protected SsmClient ssmClient() {
        if (this.ssmClient == null) {
            this.ssmClient = (SsmClient)SsmClient.builder().build();
        }
        return this.ssmClient;
    }
}

