/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.aws.facade.v2.internal;

import com.kdgregory.logging.aws.cloudwatch.CloudWatchWriterConfig;
import com.kdgregory.logging.aws.facade.v2.internal.AssumedRoleCredentialsProviderProvider;
import com.kdgregory.logging.aws.internal.AbstractWriterConfig;
import com.kdgregory.logging.aws.kinesis.KinesisWriterConfig;
import com.kdgregory.logging.aws.sns.SNSWriterConfig;
import com.kdgregory.logging.common.internal.Utils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClientBuilder;
import software.amazon.awssdk.services.kinesis.KinesisClient;
import software.amazon.awssdk.services.kinesis.KinesisClientBuilder;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sns.SnsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;

public class ClientFactory<T> {
    private Class<T> clientType;
    private AbstractWriterConfig<?> config;

    public ClientFactory(Class<T> clientType, AbstractWriterConfig<?> config) {
        this.clientType = clientType;
        this.config = config;
    }

    public T create() {
        T client = this.tryInstantiateFromFactory();
        if (client != null) {
            return client;
        }
        AwsClientBuilder<?, ?> builder = this.createClientBuilder();
        this.optSetRegionOrEndpoint(builder);
        String roleToAssume = this.config.getAssumedRole();
        if (roleToAssume != null && !roleToAssume.isEmpty()) {
            this.setAssumedRoleCredentialsProvider(builder, roleToAssume);
        }
        return this.clientType.cast(builder.build());
    }

    protected T tryInstantiateFromFactory() {
        Method factoryMethod;
        String fullyQualifiedMethodName = this.config.getClientFactoryMethod();
        if (fullyQualifiedMethodName == null || fullyQualifiedMethodName.isEmpty()) {
            return null;
        }
        try {
            factoryMethod = Utils.findFullyQualifiedMethod((String)fullyQualifiedMethodName, (Class[])new Class[0]);
        }
        catch (Exception ignored) {
            try {
                factoryMethod = Utils.findFullyQualifiedMethod((String)fullyQualifiedMethodName, (Class[])new Class[]{String.class, String.class, String.class});
            }
            catch (Exception ex) {
                throw new RuntimeException("invalid factory method: " + fullyQualifiedMethodName, ex);
            }
        }
        try {
            return factoryMethod.getParameterTypes().length == 0 ? this.clientType.cast(factoryMethod.invoke(null, new Object[0])) : this.clientType.cast(factoryMethod.invoke(null, this.config.getAssumedRole(), this.config.getClientRegion(), this.config.getClientEndpoint()));
        }
        catch (Throwable ex) {
            if (ex instanceof InvocationTargetException) {
                ex = ex.getCause();
            }
            throw new RuntimeException("exception invoking factory method: " + fullyQualifiedMethodName, ex);
        }
    }

    protected AwsClientBuilder<?, ?> createClientBuilder() {
        if (this.config instanceof CloudWatchWriterConfig) {
            return new CloudWatchLogsClientBuilderBuilder().buildBuilder();
        }
        if (this.config instanceof KinesisWriterConfig) {
            return new KinesisClientBuilderBuilder().buildBuilder();
        }
        if (this.config instanceof SNSWriterConfig) {
            return new SnsClientBuilderBuilder().buildBuilder();
        }
        throw new RuntimeException("unsupported configuration type: " + this.config.getClass());
    }

    protected void optSetRegionOrEndpoint(AwsClientBuilder<?, ?> builder) {
        String region = this.config.getClientRegion();
        String endpoint = this.config.getClientEndpoint();
        if (endpoint != null && !endpoint.isEmpty()) {
            builder.endpointOverride(URI.create(endpoint));
        }
        if (region != null && !region.isEmpty()) {
            builder.region(Region.of((String)region));
        }
    }

    protected void setAssumedRoleCredentialsProvider(AwsClientBuilder<?, ?> builder, String roleToAssume) {
        StsAssumeRoleCredentialsProvider credentialsProvider = new AssumedRoleCredentialsProviderProvider().provideProvider(roleToAssume);
        builder.credentialsProvider((AwsCredentialsProvider)credentialsProvider);
    }

    private static class SnsClientBuilderBuilder {
        private SnsClientBuilderBuilder() {
        }

        public SnsClientBuilder buildBuilder() {
            return SnsClient.builder();
        }
    }

    private static class KinesisClientBuilderBuilder {
        private KinesisClientBuilderBuilder() {
        }

        public KinesisClientBuilder buildBuilder() {
            return KinesisClient.builder();
        }
    }

    private static class CloudWatchLogsClientBuilderBuilder {
        private CloudWatchLogsClientBuilderBuilder() {
        }

        public CloudWatchLogsClientBuilder buildBuilder() {
            return CloudWatchLogsClient.builder();
        }
    }
}

