/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.aws.facade.v2;

import com.kdgregory.logging.aws.cloudwatch.CloudWatchWriterConfig;
import com.kdgregory.logging.aws.facade.CloudWatchFacade;
import com.kdgregory.logging.aws.facade.CloudWatchFacadeException;
import com.kdgregory.logging.aws.facade.v2.internal.ClientFactory;
import com.kdgregory.logging.aws.internal.AbstractWriterConfig;
import com.kdgregory.logging.common.LogMessage;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsException;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogGroupRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogStreamRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogGroupsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogStreamsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.InputLogEvent;
import software.amazon.awssdk.services.cloudwatchlogs.model.InvalidParameterException;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogGroup;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogStream;
import software.amazon.awssdk.services.cloudwatchlogs.model.OperationAbortedException;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutLogEventsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutRetentionPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.cloudwatchlogs.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeLogGroupsIterable;
import software.amazon.awssdk.services.cloudwatchlogs.paginators.DescribeLogStreamsIterable;

public class CloudWatchFacadeImpl
implements CloudWatchFacade {
    private CloudWatchWriterConfig config;
    protected CloudWatchLogsClient client;

    public CloudWatchFacadeImpl(CloudWatchWriterConfig config) {
        this.config = config;
    }

    public String findLogGroup() {
        String logGroupName = this.config.getLogGroupName();
        try {
            DescribeLogGroupsRequest request = (DescribeLogGroupsRequest)DescribeLogGroupsRequest.builder().logGroupNamePrefix(logGroupName).build();
            DescribeLogGroupsIterable itx = this.client().describeLogGroupsPaginator(request);
            for (LogGroup logGroup : itx.logGroups()) {
                if (!logGroup.logGroupName().equals(logGroupName)) continue;
                return logGroup.arn();
            }
            return null;
        }
        catch (Exception ex) {
            CloudWatchFacadeException ex2 = this.transformException("findLogGroup", ex);
            if (ex2.isRetryable()) {
                return null;
            }
            throw ex2;
        }
    }

    public void createLogGroup() {
        String logGroupName = this.config.getLogGroupName();
        try {
            CreateLogGroupRequest request = (CreateLogGroupRequest)CreateLogGroupRequest.builder().logGroupName(logGroupName).build();
            this.client().createLogGroup(request);
            return;
        }
        catch (ResourceAlreadyExistsException ex) {
            return;
        }
        catch (Exception ex) {
            throw this.transformException("createLogGroup", ex);
        }
    }

    public void setLogGroupRetention() {
        if (this.config.getRetentionPeriod() == null) {
            return;
        }
        try {
            PutRetentionPolicyRequest request = (PutRetentionPolicyRequest)PutRetentionPolicyRequest.builder().logGroupName(this.config.getLogGroupName()).retentionInDays(this.config.getRetentionPeriod()).build();
            this.client().putRetentionPolicy(request);
        }
        catch (InvalidParameterException ex) {
            throw new CloudWatchFacadeException("invalid retention period: " + this.config.getRetentionPeriod(), CloudWatchFacadeException.ReasonCode.INVALID_CONFIGURATION, false, "setLogGroupRetention", new Object[]{this.config.getLogGroupName()});
        }
        catch (Exception ex) {
            throw this.transformException("setLogGroupRetention", ex);
        }
    }

    public String findLogStream() {
        String logGroupName = this.config.getLogGroupName();
        String logStreamName = this.config.getLogStreamName();
        DescribeLogStreamsRequest request = (DescribeLogStreamsRequest)DescribeLogStreamsRequest.builder().logGroupName(logGroupName).logStreamNamePrefix(logStreamName).build();
        try {
            DescribeLogStreamsIterable itx = this.client().describeLogStreamsPaginator(request);
            for (LogStream stream : itx.logStreams()) {
                if (!stream.logStreamName().equals(this.config.getLogStreamName())) continue;
                return stream.arn();
            }
            return null;
        }
        catch (ResourceNotFoundException ex) {
            return null;
        }
        catch (Exception ex) {
            CloudWatchFacadeException ex2 = this.transformException("findLogStream", ex);
            if (ex2.isRetryable()) {
                return null;
            }
            throw ex2;
        }
    }

    public void createLogStream() {
        String logGroupName = this.config.getLogGroupName();
        String logStreamName = this.config.getLogStreamName();
        try {
            CreateLogStreamRequest request = (CreateLogStreamRequest)CreateLogStreamRequest.builder().logGroupName(logGroupName).logStreamName(logStreamName).build();
            this.client().createLogStream(request);
            return;
        }
        catch (ResourceAlreadyExistsException ex) {
            return;
        }
        catch (ResourceNotFoundException ex) {
            throw new CloudWatchFacadeException("log group missing", CloudWatchFacadeException.ReasonCode.MISSING_LOG_GROUP, false, "createLogStream", new Object[]{this.config.getLogGroupName()});
        }
        catch (Exception ex) {
            throw this.transformException("createLogStream", ex);
        }
    }

    public void putEvents(List<LogMessage> messages) {
        if (messages.isEmpty()) {
            return;
        }
        List events = messages.stream().map(m -> (InputLogEvent)InputLogEvent.builder().timestamp(Long.valueOf(m.getTimestamp())).message(m.getMessage()).build()).collect(Collectors.toList());
        PutLogEventsRequest request = (PutLogEventsRequest)PutLogEventsRequest.builder().logGroupName(this.config.getLogGroupName()).logStreamName(this.config.getLogStreamName()).logEvents(events).build();
        try {
            this.client().putLogEvents(request);
        }
        catch (ResourceNotFoundException ex) {
            throw new CloudWatchFacadeException("missing log group", CloudWatchFacadeException.ReasonCode.MISSING_LOG_GROUP, false, "putEvents", new Object[]{this.config.getLogGroupName(), this.config.getLogStreamName()});
        }
        catch (Exception ex) {
            throw this.transformException("putEvents", ex);
        }
    }

    public void shutdown() {
        this.client().close();
    }

    protected CloudWatchLogsClient client() {
        if (this.client == null) {
            this.client = new ClientFactory<CloudWatchLogsClient>(CloudWatchLogsClient.class, (AbstractWriterConfig<?>)this.config).create();
        }
        return this.client;
    }

    private CloudWatchFacadeException transformException(String functionName, Exception cause) {
        boolean isRetryable;
        String message;
        CloudWatchFacadeException.ReasonCode reason;
        if (cause == null) {
            reason = CloudWatchFacadeException.ReasonCode.UNEXPECTED_EXCEPTION;
            message = "coding error; exception not provided";
            isRetryable = false;
        } else if (cause instanceof OperationAbortedException) {
            reason = CloudWatchFacadeException.ReasonCode.ABORTED;
            message = "request aborted";
            isRetryable = true;
        } else if (cause instanceof CloudWatchLogsException) {
            String errorCode;
            CloudWatchLogsException ex = (CloudWatchLogsException)cause;
            String string = errorCode = ex.awsErrorDetails() != null ? ex.awsErrorDetails().errorCode() : null;
            if ("ThrottlingException".equals(errorCode)) {
                reason = CloudWatchFacadeException.ReasonCode.THROTTLING;
                message = "request throttled";
                isRetryable = true;
            } else {
                reason = CloudWatchFacadeException.ReasonCode.UNEXPECTED_EXCEPTION;
                message = "service exception: " + cause.getMessage();
                isRetryable = false;
            }
        } else {
            reason = CloudWatchFacadeException.ReasonCode.UNEXPECTED_EXCEPTION;
            message = "unexpected exception: " + cause.getMessage();
            isRetryable = false;
        }
        return new CloudWatchFacadeException(message, (Throwable)cause, reason, isRetryable, functionName, new Object[]{this.config.getLogGroupName(), this.config.getLogStreamName()});
    }
}

