/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.aws.facade.v2.internal;

import java.util.regex.Pattern;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.IamClientBuilder;
import software.amazon.awssdk.services.iam.model.Role;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;

public class AssumedRoleCredentialsProviderProvider {
    private IamClient iamClient;

    public StsAssumeRoleCredentialsProvider provideProvider(String roleNameOrArn) {
        String roleArn = this.retrieveArn(roleNameOrArn);
        if (roleArn == null) {
            throw new RuntimeException("no such role: " + roleNameOrArn);
        }
        StsClient stsClient = (StsClient)StsClient.builder().build();
        AssumeRoleRequest request = (AssumeRoleRequest)AssumeRoleRequest.builder().roleArn(roleArn).roleSessionName("com.kdgregory.logging.aws").build();
        return (StsAssumeRoleCredentialsProvider)((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(stsClient)).refreshRequest(request).build();
    }

    protected IamClient iamClient() {
        if (this.iamClient == null) {
            this.iamClient = (IamClient)((IamClientBuilder)IamClient.builder().region(Region.AWS_GLOBAL)).build();
        }
        return this.iamClient;
    }

    public String retrieveArn(String nameOrArn) {
        if (Pattern.matches("arn:.*:iam::\\d{12}:role/.*", nameOrArn)) {
            return nameOrArn;
        }
        for (Role role : this.iamClient().listRolesPaginator().roles()) {
            if (!role.roleName().equals(nameOrArn) && !role.arn().equals(nameOrArn)) continue;
            return role.arn();
        }
        return null;
    }
}

