/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.aws.common;

import com.amazonaws.regions.Regions;
import com.kdgregory.logging.common.factories.ClientFactory;
import com.kdgregory.logging.common.util.InternalLogger;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class DefaultClientFactory<AWSClientType>
implements ClientFactory<AWSClientType> {
    private Class<AWSClientType> clientType;
    private String factoryMethodName;
    private String region;
    private String endpoint;
    private InternalLogger logger;
    protected Map<String, String> factoryClasses = new HashMap<String, String>();
    protected Map<String, String> clientClasses;

    public DefaultClientFactory(Class<AWSClientType> clientType, String factoryMethod, String region, String endpoint, InternalLogger logger) {
        this.factoryClasses.put("com.amazonaws.services.logs.AWSLogs", "com.amazonaws.services.logs.AWSLogsClientBuilder");
        this.factoryClasses.put("com.amazonaws.services.kinesis.AmazonKinesis", "com.amazonaws.services.kinesis.AmazonKinesisClientBuilder");
        this.factoryClasses.put("com.amazonaws.services.sns.AmazonSNS", "com.amazonaws.services.sns.AmazonSNSClientBuilder");
        this.clientClasses = new HashMap<String, String>();
        this.clientClasses.put("com.amazonaws.services.logs.AWSLogs", "com.amazonaws.services.logs.AWSLogsClient");
        this.clientClasses.put("com.amazonaws.services.kinesis.AmazonKinesis", "com.amazonaws.services.kinesis.AmazonKinesisClient");
        this.clientClasses.put("com.amazonaws.services.sns.AmazonSNS", "com.amazonaws.services.sns.AmazonSNSClient");
        this.clientType = clientType;
        this.factoryMethodName = factoryMethod;
        this.region = region;
        this.endpoint = endpoint;
        this.logger = logger;
    }

    @Override
    public AWSClientType createClient() {
        AWSClientType client = this.tryFactory();
        if (client != null) {
            return client;
        }
        client = this.tryBuilder();
        if (client != null) {
            return client;
        }
        client = this.tryConstructor();
        if (client != null) {
            return client;
        }
        return null;
    }

    protected AWSClientType tryFactory() {
        if (this.factoryMethodName == null || this.factoryMethodName.isEmpty()) {
            return null;
        }
        int methodIdx = this.factoryMethodName.lastIndexOf(46);
        if (methodIdx < 0) {
            throw new IllegalArgumentException("invalid client factory configuration: " + this.factoryMethodName);
        }
        this.logger.debug("creating client via factory method: " + this.factoryMethodName);
        try {
            Class<?> factoryKlass = Class.forName(this.factoryMethodName.substring(0, methodIdx));
            Method factoryMethod = factoryKlass.getDeclaredMethod(this.factoryMethodName.substring(methodIdx + 1), new Class[0]);
            return this.clientType.cast(factoryMethod.invoke(null, new Object[0]));
        }
        catch (Exception ex) {
            this.logger.error("failed to create client via configured factory: " + this.factoryMethodName, ex);
            return null;
        }
    }

    public AWSClientType tryBuilder() {
        try {
            Object builder = this.createBuilder();
            if (builder == null) {
                return null;
            }
            this.logger.debug("creating client via SDK builder");
            if (this.region != null && !this.region.isEmpty()) {
                this.logger.debug("setting region: " + this.region);
                this.maybeSetAttribute(builder, "setRegion", this.region);
            }
            Method clientFactoryMethod = builder.getClass().getMethod("build", new Class[0]);
            return this.clientType.cast(clientFactoryMethod.invoke(builder, new Object[0]));
        }
        catch (Exception ex) {
            this.logger.error("failed to invoke builder", ex);
            return null;
        }
    }

    protected Object createBuilder() {
        try {
            String builderClassName = this.factoryClasses.get(this.clientType.getName());
            if (builderClassName == null) {
                return null;
            }
            Class<?> builderClass = Class.forName(builderClassName);
            Method factoryMethod = builderClass.getMethod("standard", new Class[0]);
            return factoryMethod.invoke(null, new Object[0]);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    protected AWSClientType tryConstructor() {
        this.logger.debug("creating client via constructor");
        AWSClientType client = this.invokeConstructor();
        if (client == null) {
            return null;
        }
        if (this.maybeSetAttribute(client, "setEndpoint", this.endpoint)) {
            this.logger.debug("setting endpoint: " + this.endpoint);
            return client;
        }
        if (this.maybeSetRegion(client, this.region) || this.maybeSetRegion(client, System.getenv("AWS_REGION"))) {
            return client;
        }
        return client;
    }

    protected AWSClientType invokeConstructor() {
        String clientClass = this.clientClasses.get(this.clientType.getName());
        if (clientClass == null) {
            this.logger.error("unsupported client type: " + this.clientType, null);
            return null;
        }
        try {
            Class<?> klass = Class.forName(clientClass);
            return (AWSClientType)klass.newInstance();
        }
        catch (Exception ex) {
            this.logger.error("failed to instantiate service client: " + clientClass, ex);
            return null;
        }
    }

    protected boolean maybeSetRegion(AWSClientType client, String value) {
        if (client == null) {
            return false;
        }
        if (value == null || value.isEmpty()) {
            return false;
        }
        try {
            Regions resolvedRegion = Regions.fromName((String)value);
            this.logger.debug("setting region: " + value);
            return this.maybeSetAttribute(client, "configureRegion", resolvedRegion);
        }
        catch (IllegalArgumentException ex) {
            this.logger.error("unsupported/invalid region: " + value, null);
            return false;
        }
    }

    protected boolean maybeSetAttribute(Object client, String setterName, Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof String && ((String)value).isEmpty()) {
            return false;
        }
        try {
            Method setter = client.getClass().getMethod(setterName, value.getClass());
            setter.invoke(client, value);
            return true;
        }
        catch (Exception ex) {
            this.logger.error("failed to set attribute: " + setterName + "(" + value + ")", ex);
            return false;
        }
    }
}

