/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.aws.common;

import com.amazonaws.util.EC2MetadataUtils;
import com.kdgregory.logging.aws.internal.Utils;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class Substitutions {
    private Date currentDate;
    private String sequence;
    private RuntimeMXBean runtimeMx;
    private volatile String date;
    private volatile String timestamp;
    private volatile String hourlyTimestamp;
    private volatile String startupTimestamp;
    private volatile String pid;
    private volatile String hostname;
    private volatile String accountId;
    private volatile String instanceId;

    public Substitutions(Date currentDate, int sequence) {
        this.currentDate = currentDate;
        this.sequence = String.valueOf(sequence);
        this.runtimeMx = ManagementFactory.getRuntimeMXBean();
    }

    public String perform(String input) {
        if (input == null) {
            return null;
        }
        String output = input;
        while (!(output = this.substitute("{sequence}", this.sequence, this.substituteDate(this.substituteTimestamp(this.substituteHourlyTimestamp(this.substituteStartupTimestamp(this.substitutePid(this.substituteHostname(this.substituteAwsAccountId(this.substituteEC2InstanceId(this.substituteEC2Region(this.substituteSysprop(this.substituteEnvar(input = output))))))))))))).equals(input)) {
        }
        return output;
    }

    private String substitute(String input, int start, String tag, String value) {
        return input.substring(0, start) + value + input.substring(start + tag.length(), input.length());
    }

    private String substitute(String tag, String value, String input) {
        if (input == null) {
            return "";
        }
        if (value == null) {
            return input;
        }
        int index = input.indexOf(tag);
        if (index < 0) {
            return input;
        }
        return this.substitute(input, index, tag, value);
    }

    private String substituteDate(String input) {
        String tag = "{date}";
        int index = input.indexOf(tag);
        if (index < 0) {
            return input;
        }
        if (this.date == null) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
            formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.date = formatter.format(this.currentDate);
        }
        return this.substitute(input, index, tag, this.date);
    }

    private String substituteTimestamp(String input) {
        String tag = "{timestamp}";
        int index = input.indexOf(tag);
        if (index < 0) {
            return input;
        }
        if (this.timestamp == null) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
            formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.timestamp = formatter.format(this.currentDate);
        }
        return this.substitute(input, index, tag, this.timestamp);
    }

    private String substituteHourlyTimestamp(String input) {
        String tag = "{hourlyTimestamp}";
        int index = input.indexOf(tag);
        if (index < 0) {
            return input;
        }
        if (this.hourlyTimestamp == null) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHH'0000'");
            formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.hourlyTimestamp = formatter.format(this.currentDate);
        }
        return this.substitute(input, index, tag, this.hourlyTimestamp);
    }

    private String substituteStartupTimestamp(String input) {
        String tag = "{startupTimestamp}";
        int index = input.indexOf(tag);
        if (index < 0) {
            return input;
        }
        if (this.startupTimestamp == null) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
            formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.startupTimestamp = formatter.format(new Date(this.runtimeMx.getStartTime()));
        }
        return this.substitute(input, index, tag, this.startupTimestamp);
    }

    private String substitutePid(String input) {
        String tag = "{pid}";
        int index = input.indexOf(tag);
        if (index < 0) {
            return input;
        }
        if (this.pid == null) {
            String vmName = this.runtimeMx.getName();
            this.pid = vmName.indexOf(64) > 0 ? vmName.substring(0, vmName.indexOf(64)) : "unknown";
        }
        return this.substitute(input, index, tag, this.pid);
    }

    private String substituteHostname(String input) {
        String tag = "{hostname}";
        int index = input.indexOf(tag);
        if (index < 0) {
            return input;
        }
        if (this.hostname == null) {
            String vmName = this.runtimeMx.getName();
            this.hostname = vmName.indexOf(64) > 0 ? vmName.substring(vmName.indexOf(64) + 1, vmName.length()) : "unknown";
        }
        return this.substitute(input, index, tag, this.hostname);
    }

    private String substituteAwsAccountId(String input) {
        String tag = "{aws:accountId}";
        int index = input.indexOf(tag);
        if (index < 0) {
            return input;
        }
        if (this.accountId == null) {
            this.accountId = Utils.retrieveAWSAccountId();
            this.accountId = this.accountId != null ? this.accountId : "unknown-account";
        }
        return this.substitute(input, index, tag, this.accountId);
    }

    private String substituteEC2InstanceId(String input) {
        String tag = "{ec2:instanceId}";
        int index = input.indexOf(tag);
        if (index < 0 && (index = input.indexOf(tag = "{instanceId}")) < 0) {
            return input;
        }
        if (this.instanceId == null) {
            this.instanceId = EC2MetadataUtils.getInstanceId();
            if (this.instanceId == null || this.instanceId.length() == 0) {
                this.instanceId = "unknown-instance";
            }
        }
        return this.substitute(input, index, tag, this.instanceId);
    }

    private String substituteEC2Region(String input) {
        String tag = "{ec2:region}";
        int index = input.indexOf(tag);
        if (index < 0) {
            return input;
        }
        String region = EC2MetadataUtils.getEC2InstanceRegion();
        if (region == null || region.length() == 0) {
            return input;
        }
        return this.substitute(tag, region, input);
    }

    private String substituteSysprop(String input) {
        String propValue;
        String rawPropName = this.extractPropName("sysprop", input);
        if (rawPropName == null) {
            return input;
        }
        String[] parts = rawPropName.split(":");
        String string = propValue = parts[0].length() == 0 ? null : System.getProperty(parts[0]);
        if (propValue == null && parts.length == 2) {
            propValue = parts[1];
        }
        return this.substitute("{sysprop:" + rawPropName + "}", propValue, input);
    }

    private String substituteEnvar(String input) {
        String propValue;
        String rawPropName = this.extractPropName("env", input);
        if (rawPropName == null) {
            return input;
        }
        String[] parts = rawPropName.split(":");
        String string = propValue = parts[0].length() == 0 ? null : System.getenv(parts[0]);
        if (propValue == null && parts.length == 2) {
            propValue = parts[1];
        }
        return this.substitute("{env:" + rawPropName + "}", propValue, input);
    }

    private String extractPropName(String tagType, String input) {
        String tagForm = "{" + tagType + ":";
        int index1 = input.indexOf(tagForm);
        if (index1 < 0) {
            return null;
        }
        int index2 = input.indexOf("}", index1);
        if (index2 < 0) {
            return null;
        }
        return input.substring(index1 + tagForm.length(), index2);
    }
}

