/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.aws.internal;

import com.kdgregory.logging.aws.internal.AbstractWriterConfig;
import com.kdgregory.logging.aws.internal.AbstractWriterStatistics;
import com.kdgregory.logging.common.LogMessage;
import com.kdgregory.logging.common.LogWriter;
import com.kdgregory.logging.common.factories.ClientFactory;
import com.kdgregory.logging.common.util.DiscardAction;
import com.kdgregory.logging.common.util.InternalLogger;
import com.kdgregory.logging.common.util.MessageQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractLogWriter<ConfigType extends AbstractWriterConfig, StatsType extends AbstractWriterStatistics, AWSClientType>
implements LogWriter {
    private static final long NEVER_SHUTDOWN = Long.MAX_VALUE;
    protected ConfigType config;
    protected StatsType stats;
    protected InternalLogger logger;
    private ClientFactory<AWSClientType> clientFactory;
    protected AWSClientType client;
    private MessageQueue messageQueue;
    private Thread dispatchThread;
    private volatile boolean initializationComplete;
    private volatile long shutdownTime = Long.MAX_VALUE;
    private volatile Thread shutdownHook;
    private volatile int batchCount;

    public AbstractLogWriter(ConfigType config, StatsType appenderStats, InternalLogger logger, ClientFactory<AWSClientType> clientFactory) {
        this.config = config;
        this.stats = appenderStats;
        this.logger = logger;
        this.clientFactory = clientFactory;
        this.messageQueue = new MessageQueue(((AbstractWriterConfig)config).discardThreshold, ((AbstractWriterConfig)config).discardAction);
        ((AbstractWriterStatistics)this.stats).setMessageQueue(this.messageQueue);
    }

    public long getBatchDelay() {
        return ((AbstractWriterConfig)this.config).batchDelay;
    }

    public int getBatchCount() {
        return this.batchCount;
    }

    @Override
    public void run() {
        this.logger.debug("log writer starting (thread: " + Thread.currentThread().getName() + ")");
        if (!this.initialize()) {
            return;
        }
        this.logger.debug("log writer initialization complete (thread: " + Thread.currentThread().getName() + ")");
        this.dispatchThread = Thread.currentThread();
        do {
            this.processBatch(this.shutdownTime);
        } while (this.keepRunning());
        this.cleanup();
        this.logger.debug("log-writer shut down (thread: " + Thread.currentThread().getName() + " (#" + Thread.currentThread().getId() + ")");
    }

    @Override
    public void setBatchDelay(long value) {
        ((AbstractWriterConfig)this.config).batchDelay = value;
    }

    @Override
    public void setDiscardThreshold(int value) {
        this.messageQueue.setDiscardThreshold(value);
    }

    @Override
    public void setDiscardAction(DiscardAction value) {
        this.messageQueue.setDiscardAction(value);
    }

    @Override
    public void setShutdownHook(Thread shutdownHook) {
        this.shutdownHook = shutdownHook;
    }

    @Override
    public void addMessage(LogMessage message) {
        if (this.isMessageTooLarge(message)) {
            throw new IllegalArgumentException("attempted to enqueue a too-large message");
        }
        this.messageQueue.enqueue(message);
    }

    @Override
    public boolean initialize() {
        boolean success = true;
        try {
            this.client = this.clientFactory.createClient();
            success = this.ensureDestinationAvailable();
        }
        catch (Exception ex) {
            this.reportError("exception in initializer", ex);
            success = false;
        }
        if (!success) {
            this.messageQueue.setDiscardThreshold(0);
            this.messageQueue.setDiscardAction(DiscardAction.oldest);
        }
        this.initializationComplete = true;
        return success;
    }

    @Override
    public boolean waitUntilInitialized(long millisToWait) {
        long timeoutAt = System.currentTimeMillis() + millisToWait;
        while (!this.initializationComplete && System.currentTimeMillis() < timeoutAt) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                return false;
            }
        }
        return this.initializationComplete;
    }

    @Override
    public synchronized void processBatch(long waitUntil) {
        List<LogMessage> currentBatch = this.buildBatch(waitUntil);
        if (currentBatch.size() > 0) {
            ++this.batchCount;
            List<LogMessage> failures = this.sendBatch(currentBatch);
            this.requeueMessages(failures);
            ((AbstractWriterStatistics)this.stats).setMessagesRequeuedLastBatch(failures.size());
            ((AbstractWriterStatistics)this.stats).setMessagesSentLastBatch(currentBatch.size() - failures.size());
            ((AbstractWriterStatistics)this.stats).updateMessagesSent(currentBatch.size() - failures.size());
        }
    }

    @Override
    public void stop() {
        if (this.shutdownTime != Long.MAX_VALUE) {
            return;
        }
        this.shutdownTime = System.currentTimeMillis() + ((AbstractWriterConfig)this.config).batchDelay;
        if (this.dispatchThread != null) {
            this.dispatchThread.interrupt();
        }
    }

    @Override
    public void waitUntilStopped(long millisToWait) {
        try {
            if (this.dispatchThread != Thread.currentThread()) {
                this.dispatchThread.join(millisToWait);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() {
        this.stopAWSClient();
        if (this.shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (Exception exception) {
            }
            finally {
                this.shutdownHook = null;
            }
        }
    }

    private boolean keepRunning() {
        return this.shutdownTime > System.currentTimeMillis() || !this.messageQueue.isEmpty();
    }

    protected List<LogMessage> buildBatch(long waitUntil) {
        ArrayList<LogMessage> batch = new ArrayList<LogMessage>(512);
        LogMessage message = this.waitForMessage(waitUntil);
        if (message == null) {
            return batch;
        }
        long batchTimeout = System.currentTimeMillis() + ((AbstractWriterConfig)this.config).batchDelay;
        int batchBytes = 0;
        int batchMsgs = 0;
        while (message != null) {
            if (!this.withinServiceLimits(batchBytes += this.effectiveSize(message), ++batchMsgs)) {
                this.messageQueue.requeue(message);
                break;
            }
            batch.add(message);
            message = this.waitForMessage(batchTimeout);
        }
        return batch;
    }

    private LogMessage waitForMessage(long waitUntil) {
        long waitTime = waitUntil - System.currentTimeMillis();
        return this.messageQueue.dequeue(waitTime);
    }

    private void requeueMessages(List<LogMessage> messages) {
        Collections.reverse(messages);
        for (LogMessage message : messages) {
            this.messageQueue.requeue(message);
        }
    }

    protected abstract boolean ensureDestinationAvailable();

    protected abstract List<LogMessage> sendBatch(List<LogMessage> var1);

    protected abstract int effectiveSize(LogMessage var1);

    protected abstract boolean withinServiceLimits(int var1, int var2);

    protected abstract void stopAWSClient();

    protected void reportError(String message, Exception exception) {
        this.logger.error(message, exception);
        ((AbstractWriterStatistics)this.stats).setLastError(message, exception);
    }
}

