/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.aws.sns;

import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.model.CreateTopicResult;
import com.amazonaws.services.sns.model.ListTopicsRequest;
import com.amazonaws.services.sns.model.ListTopicsResult;
import com.amazonaws.services.sns.model.PublishRequest;
import com.amazonaws.services.sns.model.Topic;
import com.kdgregory.logging.aws.internal.AbstractLogWriter;
import com.kdgregory.logging.aws.sns.SNSWriterConfig;
import com.kdgregory.logging.aws.sns.SNSWriterStatistics;
import com.kdgregory.logging.common.LogMessage;
import com.kdgregory.logging.common.factories.ClientFactory;
import com.kdgregory.logging.common.util.InternalLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class SNSLogWriter
extends AbstractLogWriter<SNSWriterConfig, SNSWriterStatistics, AmazonSNS> {
    protected String topicArn;

    public SNSLogWriter(SNSWriterConfig config, SNSWriterStatistics stats, InternalLogger logger, ClientFactory<AmazonSNS> clientFactory) {
        super(config, stats, logger, clientFactory);
        stats.setActualTopicName(config.topicName);
        stats.setActualTopicArn(config.topicArn);
        stats.setActualSubject(config.subject);
    }

    @Override
    public boolean isMessageTooLarge(LogMessage message) {
        return message.size() > 262144;
    }

    @Override
    protected boolean ensureDestinationAvailable() {
        if (((SNSWriterConfig)this.config).subject != null && !((SNSWriterConfig)this.config).subject.isEmpty()) {
            if (((SNSWriterConfig)this.config).subject.length() >= 100) {
                this.reportError("invalid subject (too long): " + ((SNSWriterConfig)this.config).subject, null);
                return false;
            }
            if (((SNSWriterConfig)this.config).subject.matches(".*[^ -}].*")) {
                this.reportError("invalid subject (disallowed characters): " + ((SNSWriterConfig)this.config).subject, null);
                return false;
            }
            if (((SNSWriterConfig)this.config).subject.startsWith(" ")) {
                this.reportError("invalid subject (starts with space): " + ((SNSWriterConfig)this.config).subject, null);
                return false;
            }
        }
        try {
            boolean topicAvailable;
            boolean bl = topicAvailable = ((SNSWriterConfig)this.config).topicArn != null ? this.configureByArn() : this.configureByName();
            if (topicAvailable) {
                ((SNSWriterStatistics)this.stats).setActualTopicArn(this.topicArn);
                ((SNSWriterStatistics)this.stats).setActualTopicName(this.topicArn.replaceAll(".*:", ""));
            }
            return topicAvailable;
        }
        catch (Exception ex) {
            this.reportError("unable to configure", ex);
            return false;
        }
    }

    @Override
    protected List<LogMessage> sendBatch(List<LogMessage> currentBatch) {
        ArrayList<LogMessage> failures = new ArrayList<LogMessage>();
        for (LogMessage message : currentBatch) {
            try {
                PublishRequest request = new PublishRequest().withTopicArn(this.topicArn).withMessage(message.getMessage());
                if (((SNSWriterConfig)this.config).subject != null) {
                    request.setSubject(((SNSWriterConfig)this.config).subject);
                }
                ((AmazonSNS)this.client).publish(request);
            }
            catch (Exception ex) {
                ((SNSWriterStatistics)this.stats).setLastError(null, ex);
                failures.add(message);
            }
        }
        return failures;
    }

    @Override
    protected int effectiveSize(LogMessage message) {
        return message.size();
    }

    @Override
    protected boolean withinServiceLimits(int batchBytes, int numMessages) {
        return batchBytes <= 262144 && numMessages <= 1;
    }

    @Override
    protected void stopAWSClient() {
        ((AmazonSNS)this.client).shutdown();
    }

    private boolean configureByArn() {
        if (this.retrieveAllTopics().contains(((SNSWriterConfig)this.config).topicArn)) {
            this.topicArn = ((SNSWriterConfig)this.config).topicArn;
            return true;
        }
        this.reportError("topic does not exist: " + ((SNSWriterConfig)this.config).topicArn, null);
        return false;
    }

    private boolean configureByName() {
        String topicName = ((SNSWriterConfig)this.config).topicName;
        if (!Pattern.matches("[A-Za-z0-9_-]{1,256}", ((SNSWriterConfig)this.config).topicName)) {
            this.reportError("invalid topic name: " + topicName, null);
            return false;
        }
        this.topicArn = this.retrieveAllTopicsByName().get(((SNSWriterConfig)this.config).topicName);
        if (this.topicArn != null) {
            return true;
        }
        if (((SNSWriterConfig)this.config).autoCreate) {
            this.logger.debug("creating SNS topic: " + topicName);
            CreateTopicResult response = ((AmazonSNS)this.client).createTopic(topicName);
            this.topicArn = response.getTopicArn();
            return true;
        }
        this.reportError("topic does not exist and auto-create not enabled: " + topicName, null);
        return false;
    }

    private Set<String> retrieveAllTopics() {
        HashSet<String> result = new HashSet<String>();
        ListTopicsRequest request = new ListTopicsRequest();
        ListTopicsResult response = null;
        do {
            response = ((AmazonSNS)this.client).listTopics(request);
            for (Topic topic : response.getTopics()) {
                result.add(topic.getTopicArn());
            }
            request.setNextToken(response.getNextToken());
        } while (response.getNextToken() != null);
        return result;
    }

    private Map<String, String> retrieveAllTopicsByName() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String arn : this.retrieveAllTopics()) {
            String topicName = arn.replaceFirst(".*:", "");
            result.put(topicName, arn);
        }
        return result;
    }
}

