/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.aws.common;

import com.kdgregory.logging.aws.internal.clientfactory.BuilderClientFactory;
import com.kdgregory.logging.aws.internal.clientfactory.ConstructorClientFactory;
import com.kdgregory.logging.aws.internal.clientfactory.StaticMethodClientFactory;
import com.kdgregory.logging.common.factories.ClientFactory;
import com.kdgregory.logging.common.factories.ClientFactoryException;
import com.kdgregory.logging.common.util.InternalLogger;
import java.util.HashMap;
import java.util.Map;

public class DefaultClientFactory<AWSClientType>
implements ClientFactory<AWSClientType> {
    protected Map<String, String> factoryClasses = new HashMap<String, String>();
    protected Map<String, String> clientClasses;
    protected ClientFactory<AWSClientType> staticMethodClientFactory;
    protected ClientFactory<AWSClientType> builderClientFactory;
    protected ClientFactory<AWSClientType> constructorClientFactory;

    public DefaultClientFactory(Class<AWSClientType> clientType, String factoryMethod, String assumedRole, String region, String endpoint, InternalLogger logger) {
        this.factoryClasses.put("com.amazonaws.services.logs.AWSLogs", "com.amazonaws.services.logs.AWSLogsClientBuilder");
        this.factoryClasses.put("com.amazonaws.services.kinesis.AmazonKinesis", "com.amazonaws.services.kinesis.AmazonKinesisClientBuilder");
        this.factoryClasses.put("com.amazonaws.services.sns.AmazonSNS", "com.amazonaws.services.sns.AmazonSNSClientBuilder");
        this.clientClasses = new HashMap<String, String>();
        this.clientClasses.put("com.amazonaws.services.logs.AWSLogs", "com.amazonaws.services.logs.AWSLogsClient");
        this.clientClasses.put("com.amazonaws.services.kinesis.AmazonKinesis", "com.amazonaws.services.kinesis.AmazonKinesisClient");
        this.clientClasses.put("com.amazonaws.services.sns.AmazonSNS", "com.amazonaws.services.sns.AmazonSNSClient");
        this.staticMethodClientFactory = new StaticMethodClientFactory<AWSClientType>(clientType, factoryMethod, assumedRole, region, endpoint, logger);
        this.builderClientFactory = new BuilderClientFactory<AWSClientType>(clientType, this.factoryClasses.get(clientType.getName()), assumedRole, region, logger);
        this.constructorClientFactory = new ConstructorClientFactory<AWSClientType>(clientType, this.clientClasses.get(clientType.getName()), region, endpoint, logger);
    }

    @Override
    public AWSClientType createClient() {
        AWSClientType client = this.staticMethodClientFactory.createClient();
        if (client != null) {
            return client;
        }
        client = this.builderClientFactory.createClient();
        if (client != null) {
            return client;
        }
        client = this.constructorClientFactory.createClient();
        if (client != null) {
            return client;
        }
        throw new ClientFactoryException("I don't know how to create client (perhaps you're missing an SDK dependency?)");
    }
}

