/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.aws.internal.retrievers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class AbstractReflectionBasedRetriever {
    public Throwable exception;
    public Class<?> builderKlass;
    public Class<?> clientKlass;
    public Class<?> requestKlass;
    public Class<?> responseKlass;

    public AbstractReflectionBasedRetriever(String builderClassName, String clientClassName, String requestClassName, String responseClassName) {
        this.builderKlass = this.loadClass(builderClassName);
        this.clientKlass = this.loadClass(clientClassName);
        this.requestKlass = this.loadClass(requestClassName);
        this.responseKlass = this.loadClass(responseClassName);
    }

    public AbstractReflectionBasedRetriever(String clientClassName, String requestClassName, String responseClassName) {
        this(null, clientClassName, requestClassName, responseClassName);
    }

    public AbstractReflectionBasedRetriever(String className) {
        this(null, className, null, null);
    }

    public AbstractReflectionBasedRetriever() {
    }

    public Class<?> loadClass(String className) {
        if (className == null) {
            return null;
        }
        try {
            return Class.forName(className);
        }
        catch (Throwable ex) {
            this.exception = ex;
            return null;
        }
    }

    public Object instantiate(Class<?> klass) {
        if (this.exception != null || klass == null) {
            return null;
        }
        try {
            return klass.newInstance();
        }
        catch (Throwable ex) {
            this.exception = ex;
            return null;
        }
    }

    public Object invokeBuilder() {
        if (this.exception != null || this.builderKlass == null || this.clientKlass == null) {
            return null;
        }
        return this.clientKlass.cast(this.invokeMethod(this.builderKlass, null, "defaultClient", null, null));
    }

    public Object invokeMethod(Class<?> objKlass, Object obj, String methodName, Class<?> paramKlass, Object value) {
        if (this.exception != null || objKlass == null) {
            return null;
        }
        try {
            if (paramKlass != null) {
                Method method = objKlass.getMethod(methodName, paramKlass);
                return method.invoke(obj, value);
            }
            Method method = objKlass.getMethod(methodName, new Class[0]);
            return method.invoke(obj, new Object[0]);
        }
        catch (InvocationTargetException ex) {
            this.exception = ex.getCause();
            return null;
        }
        catch (Throwable ex) {
            this.exception = ex;
            return null;
        }
    }

    public Object invokeStatic(Class<?> objKlass, String methodName, Class<?> paramKlass, Object value) {
        return this.invokeMethod(objKlass, null, methodName, paramKlass, value);
    }

    public void setRequestValue(Object request, String methodName, Class<?> valueKlass, Object value) {
        this.invokeMethod(this.requestKlass, request, methodName, valueKlass, value);
    }

    public Object invokeRequest(Object client, String methodName, Object value) {
        return this.invokeMethod(this.clientKlass, client, methodName, this.requestKlass, value);
    }

    public <T> T getResponseValue(Object response, String methodName, Class<T> resultKlass) {
        if (resultKlass == null) {
            return null;
        }
        return resultKlass.cast(this.invokeMethod(this.responseKlass, response, methodName, null, null));
    }

    public void shutdown(Object client) {
        if (client == null) {
            return;
        }
        try {
            Method method = this.clientKlass.getMethod("shutdown", new Class[0]);
            method.invoke(client, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

