/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.aws.internal.retrievers;

import com.kdgregory.logging.aws.internal.retrievers.AbstractReflectionBasedRetriever;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class RoleArnRetriever
extends AbstractReflectionBasedRetriever {
    private Class<?> roleKlass = this.loadClass("com.amazonaws.services.identitymanagement.model.Role");

    public RoleArnRetriever() {
        super("com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient", "com.amazonaws.services.identitymanagement.model.ListRolesRequest", "com.amazonaws.services.identitymanagement.model.ListRolesResult");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String invoke(String roleName) {
        if (roleName == null) {
            return null;
        }
        if (Pattern.matches("arn:.+:iam::\\d{12}:role/.+", roleName)) {
            return roleName;
        }
        Object client = this.instantiate(this.clientKlass);
        try {
            String string;
            Object response;
            Object request = this.instantiate(this.requestKlass);
            do {
                if ((response = this.invokeRequest(client, "listRoles", request)) == null) {
                    string = null;
                    return string;
                }
                String marker = this.getResponseValue(response, "getMarker", String.class);
                this.setRequestValue(request, "setMarker", String.class, marker);
                List roles = this.getResponseValue(response, "getRoles", List.class);
                if (roles == null) {
                    roles = Collections.emptyList();
                }
                for (Object role : roles) {
                    String roleArn = (String)this.invokeMethod(this.roleKlass, role, "getArn", null, null);
                    if (!roleName.equals(this.invokeMethod(this.roleKlass, role, "getRoleName", null, null))) continue;
                    String string2 = roleArn;
                    return string2;
                }
            } while (this.getResponseValue(response, "isTruncated", Boolean.class).booleanValue());
            string = null;
            return string;
        }
        finally {
            this.shutdown(client);
        }
    }
}

