/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.common.factories;

import com.kdgregory.logging.common.LogWriter;
import com.kdgregory.logging.common.factories.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultThreadFactory
implements ThreadFactory {
    private static AtomicInteger threadNumber = new AtomicInteger(0);
    private String appenderName;

    public DefaultThreadFactory(String appenderName) {
        this.appenderName = appenderName;
    }

    @Override
    public void startLoggingThread(final LogWriter writer, boolean useShutdownHook, Thread.UncaughtExceptionHandler exceptionHandler) {
        final Thread writerThread = this.createThread(writer, exceptionHandler);
        if (useShutdownHook) {
            Thread shutdownHook = new Thread(new Runnable(){

                @Override
                public void run() {
                    writer.stop();
                    try {
                        writerThread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
            shutdownHook.setName(writerThread.getName() + "-shutdownHook");
            writer.setShutdownHook(shutdownHook);
            Runtime.getRuntime().addShutdownHook(shutdownHook);
        }
        writerThread.start();
    }

    protected Thread createThread(LogWriter writer, Thread.UncaughtExceptionHandler exceptionHandler) {
        Thread writerThread = new Thread(writer);
        writerThread.setName("com-kdgregory-aws-logwriter-" + this.appenderName + "-" + threadNumber.incrementAndGet());
        writerThread.setPriority(5);
        writerThread.setDaemon(true);
        writerThread.setUncaughtExceptionHandler(exceptionHandler);
        return writerThread;
    }
}

