/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.common.jmx;

import com.kdgregory.logging.aws.internal.AbstractWriterStatistics;
import com.kdgregory.logging.common.util.InternalLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.StandardMBean;

public abstract class AbstractJMXManager {
    protected InternalLogger logger;
    protected Map<Object, List<MBeanServer>> registrations = new IdentityHashMap<Object, List<MBeanServer>>();
    protected Map<MBeanServer, String> registrationNames = new IdentityHashMap<MBeanServer, String>();
    protected Map<String, AbstractWriterStatistics> statsBeans = new HashMap<String, AbstractWriterStatistics>();
    protected Map<String, Class<?>> statsBeanTypes = new HashMap();

    protected AbstractJMXManager(InternalLogger logger) {
        this.logger = logger;
    }

    public synchronized void addMarkerBean(Object bean, MBeanServer server, ObjectName registrationName) {
        if (this.registrationNames.containsKey(server)) {
            this.logger.warn("server already registered with name " + this.registrationNames.get(server) + " ignoring " + registrationName);
            return;
        }
        this.registrationNames.put(server, registrationName.getCanonicalName());
        List<MBeanServer> servers = this.registrations.get(bean);
        if (servers == null) {
            servers = new ArrayList<MBeanServer>();
            this.registrations.put(bean, servers);
        }
        servers.add(server);
        for (String appenderName : this.statsBeans.keySet()) {
            this.registerAppenderBean(appenderName, server);
        }
    }

    public synchronized void removeMarkerBean(Object bean) {
        List<MBeanServer> servers = this.registrations.remove(bean);
        if (servers == null) {
            this.logger.warn("JMXManager: attempt to remove unregistered StatisticsMBean");
            return;
        }
        for (MBeanServer server : servers) {
            for (String appenderName : this.statsBeans.keySet()) {
                this.unregisterAppenderBean(appenderName, server);
            }
            this.registrationNames.remove(server);
        }
    }

    public synchronized void addStatsBean(String appenderName, AbstractWriterStatistics statsBean, Class<?> statsBeanClass) {
        this.statsBeans.put(appenderName, statsBean);
        this.statsBeanTypes.put(appenderName, statsBeanClass);
        for (List<MBeanServer> servers : this.registrations.values()) {
            for (MBeanServer server : servers) {
                this.registerAppenderBean(appenderName, server);
            }
        }
    }

    public synchronized void removeStatsBean(String appenderName) {
        this.statsBeans.remove(appenderName);
        this.statsBeanTypes.remove(appenderName);
        for (List<MBeanServer> servers : this.registrations.values()) {
            for (MBeanServer server : servers) {
                this.unregisterAppenderBean(appenderName, server);
            }
        }
    }

    protected void registerAppenderBean(String appenderName, MBeanServer mbeanServer) {
        if (appenderName == null) {
            this.logger.error("JMXManager: attempted to register null appender", null);
            return;
        }
        if (mbeanServer == null) {
            this.logger.error("log4j-aws-appenders JMXManager: attempted to register null server", null);
            return;
        }
        AbstractWriterStatistics statsBean = this.statsBeans.get(appenderName);
        Class<?> statsBeanClass = this.statsBeanTypes.get(appenderName);
        if (statsBean == null || statsBeanClass == null) {
            this.logger.error("JMXManager: don't know bean or class for appender: " + appenderName, null);
            return;
        }
        try {
            StandardMBean mbean = new StandardMBean(statsBeanClass.cast(statsBean), statsBeanClass, false);
            mbeanServer.registerMBean(mbean, this.toObjectName(mbeanServer, appenderName));
        }
        catch (Exception ex) {
            this.logger.error("JMXManager: failed to register appender statistics with JMX", ex);
        }
    }

    protected void unregisterAppenderBean(String appenderName, MBeanServer mbeanServer) {
        try {
            mbeanServer.unregisterMBean(this.toObjectName(mbeanServer, appenderName));
        }
        catch (Exception ex) {
            this.logger.error("JMXManager: failed to unregister appender statistics with JMX", ex);
        }
    }

    private ObjectName toObjectName(MBeanServer mbeanServer, String appenderName) throws MalformedObjectNameException {
        String nameForServer = this.registrationNames.get(mbeanServer);
        if (nameForServer == null) {
            throw new IllegalStateException("attempted to register with unrecorded MBeanServer; should never happen");
        }
        return new ObjectName(nameForServer + ",appender=" + appenderName);
    }
}

