/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.aws.common;

import com.kdgregory.logging.aws.internal.retrievers.AccountIdRetriever;
import com.kdgregory.logging.aws.internal.retrievers.EC2InstanceIdRetriever;
import com.kdgregory.logging.aws.internal.retrievers.EC2RegionRetriever;
import com.kdgregory.logging.aws.internal.retrievers.ParameterStoreRetriever;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class Substitutions {
    private SequenceSubstitutor sequenceSubstitutor;
    private DateSubstitutor dateSubstitutor;
    private TimestampSubstitutor timestampSubstitutor;
    private HourlyTimestampSubstitutor hourlyTimestampSubstitutor;
    private StartupTimestampSubstitutor startupTimestampSubstitutor;
    private PidSubstitutor pidSubstitutor;
    private HostnameSubstitutor hostnameSubstitutor;
    private SyspropSubstitutor syspropSubstitutor;
    private EnvarSubstitutor envarSubstitutor;
    private AwsAccountIdSubstitutor awsAccountIdSubstitutor;
    private EC2InstanceIdSubstitutor ec2InstanceIdSubstitutor;
    private EC2RegionSubstitutor ec2RegionSubstitutor;
    private SSMSubstitutor ssmSubstitutor;

    public Substitutions(Date now, int sequence) {
        RuntimeMXBean runtimeMx = ManagementFactory.getRuntimeMXBean();
        this.sequenceSubstitutor = new SequenceSubstitutor(sequence);
        this.dateSubstitutor = new DateSubstitutor(now);
        this.timestampSubstitutor = new TimestampSubstitutor(now);
        this.hourlyTimestampSubstitutor = new HourlyTimestampSubstitutor(now);
        this.startupTimestampSubstitutor = new StartupTimestampSubstitutor(runtimeMx);
        this.pidSubstitutor = new PidSubstitutor(runtimeMx);
        this.hostnameSubstitutor = new HostnameSubstitutor(runtimeMx);
        this.syspropSubstitutor = new SyspropSubstitutor();
        this.envarSubstitutor = new EnvarSubstitutor();
        this.awsAccountIdSubstitutor = new AwsAccountIdSubstitutor();
        this.ec2InstanceIdSubstitutor = new EC2InstanceIdSubstitutor();
        this.ec2RegionSubstitutor = new EC2RegionSubstitutor();
        this.ssmSubstitutor = new SSMSubstitutor();
    }

    public String perform(String input) {
        if (input == null) {
            return null;
        }
        String output = input;
        while (!(output = this.sequenceSubstitutor.perform(this.dateSubstitutor.perform(this.timestampSubstitutor.perform(this.hourlyTimestampSubstitutor.perform(this.startupTimestampSubstitutor.perform(this.pidSubstitutor.perform(this.hostnameSubstitutor.perform(this.syspropSubstitutor.perform(this.envarSubstitutor.perform(this.awsAccountIdSubstitutor.perform(this.ec2InstanceIdSubstitutor.perform(this.ec2RegionSubstitutor.perform(this.ssmSubstitutor.perform(input = output)))))))))))))).equals(input)) {
        }
        return output;
    }

    private class SSMSubstitutor
    extends AbstractSubstitutor {
        public SSMSubstitutor() {
            super("{ssm:");
        }

        @Override
        protected String retrieveValue(String propName) {
            return new ParameterStoreRetriever().invoke(propName);
        }
    }

    private class EC2RegionSubstitutor
    extends AbstractSubstitutor {
        public EC2RegionSubstitutor() {
            super("{ec2:region}");
        }

        @Override
        protected String retrieveValue(String ignored) {
            this.cachedValue = new EC2RegionRetriever().invoke();
            return this.cachedValue;
        }
    }

    private class EC2InstanceIdSubstitutor
    extends AbstractSubstitutor {
        public EC2InstanceIdSubstitutor() {
            super("{ec2:instanceId}", "{instanceId}");
        }

        @Override
        protected String retrieveValue(String ignored) {
            this.cachedValue = new EC2InstanceIdRetriever().invoke();
            return this.cachedValue;
        }
    }

    private class AwsAccountIdSubstitutor
    extends AbstractSubstitutor {
        public AwsAccountIdSubstitutor() {
            super("{aws:accountId}");
        }

        @Override
        protected String retrieveValue(String ignored) {
            this.cachedValue = new AccountIdRetriever().invoke();
            return this.cachedValue;
        }
    }

    private class EnvarSubstitutor
    extends AbstractSubstitutor {
        public EnvarSubstitutor() {
            super("{env:");
        }

        @Override
        protected String retrieveValue(String name) {
            if (name == null || name.isEmpty()) {
                return null;
            }
            return System.getenv(name);
        }
    }

    private class SyspropSubstitutor
    extends AbstractSubstitutor {
        public SyspropSubstitutor() {
            super("{sysprop:");
        }

        @Override
        protected String retrieveValue(String name) {
            if (name == null || name.isEmpty()) {
                return null;
            }
            return System.getProperty(name);
        }
    }

    private class HostnameSubstitutor
    extends AbstractSubstitutor {
        private RuntimeMXBean runtimeMx;

        public HostnameSubstitutor(RuntimeMXBean runtimeMx) {
            super("{hostname}");
            this.runtimeMx = runtimeMx;
        }

        @Override
        protected String retrieveValue(String ignored) {
            String vmName = this.runtimeMx.getName();
            this.cachedValue = vmName.indexOf(64) > 0 ? vmName.substring(vmName.indexOf(64) + 1) : "unknown";
            return this.cachedValue;
        }
    }

    private class PidSubstitutor
    extends AbstractSubstitutor {
        private RuntimeMXBean runtimeMx;

        public PidSubstitutor(RuntimeMXBean runtimeMx) {
            super("{pid}");
            this.runtimeMx = runtimeMx;
        }

        @Override
        protected String retrieveValue(String ignored) {
            String vmName = this.runtimeMx.getName();
            this.cachedValue = vmName.indexOf(64) > 0 ? vmName.substring(0, vmName.indexOf(64)) : "unknown";
            return this.cachedValue;
        }
    }

    private class StartupTimestampSubstitutor
    extends AbstractSubstitutor {
        private RuntimeMXBean runtimeMx;

        public StartupTimestampSubstitutor(RuntimeMXBean runtimeMx) {
            super("{startupTimestamp}");
            this.runtimeMx = runtimeMx;
        }

        @Override
        protected String retrieveValue(String ignored) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
            formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.cachedValue = formatter.format(new Date(this.runtimeMx.getStartTime()));
            return this.cachedValue;
        }
    }

    private class HourlyTimestampSubstitutor
    extends AbstractSubstitutor {
        private Date now;

        public HourlyTimestampSubstitutor(Date now) {
            super("{hourlyTimestamp}");
            this.now = now;
        }

        @Override
        protected String retrieveValue(String ignored) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHH'0000'");
            formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.cachedValue = formatter.format(this.now);
            return this.cachedValue;
        }
    }

    private class TimestampSubstitutor
    extends AbstractSubstitutor {
        private Date now;

        public TimestampSubstitutor(Date now) {
            super("{timestamp}");
            this.now = now;
        }

        @Override
        protected String retrieveValue(String ignored) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
            formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.cachedValue = formatter.format(this.now);
            return this.cachedValue;
        }
    }

    private class DateSubstitutor
    extends AbstractSubstitutor {
        private Date now;

        public DateSubstitutor(Date now) {
            super("{date}");
            this.now = now;
        }

        @Override
        protected String retrieveValue(String ignored) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
            formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.cachedValue = formatter.format(this.now);
            return this.cachedValue;
        }
    }

    private class SequenceSubstitutor
    extends AbstractSubstitutor {
        public SequenceSubstitutor(int sequence) {
            super("{sequence}");
            this.cachedValue = String.valueOf(sequence);
        }
    }

    private abstract class AbstractSubstitutor {
        private String[] tags;
        protected String cachedValue;

        public AbstractSubstitutor(String ... tags) {
            this.tags = tags;
        }

        public String perform(String input) {
            if (input == null) {
                return "";
            }
            for (String tag : this.tags) {
                input = this.trySubstitution(input, tag);
            }
            return input;
        }

        private String trySubstitution(String input, String tag) {
            int start = input.indexOf(tag);
            if (start < 0) {
                return input;
            }
            int end = input.indexOf("}", start) + 1;
            String value = this.cachedValue;
            if (value == null) {
                String actualTag = input.substring(start, end);
                String embeddedKey = actualTag.replace(tag, "").replace("}", "");
                String defaultValue = null;
                int splitPoint = embeddedKey.indexOf(58);
                if (splitPoint >= 0) {
                    defaultValue = embeddedKey.substring(splitPoint + 1);
                    embeddedKey = embeddedKey.substring(0, splitPoint);
                }
                if ((value = this.retrieveValue(embeddedKey)) == null || value.isEmpty()) {
                    value = defaultValue;
                }
            }
            if (value == null || value.isEmpty()) {
                return input;
            }
            return input.substring(0, start) + value + input.substring(end);
        }

        protected String retrieveValue(String embeddedKey) {
            return this.cachedValue;
        }
    }
}

