/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.aws.internal;

import com.kdgregory.logging.common.util.MessageQueue;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class AbstractWriterStatistics {
    private volatile MessageQueue messageQueue;
    private volatile Throwable lastError;
    private volatile String lastErrorMessage;
    private volatile Date lastErrorTimestamp;
    private volatile List<String> lastErrorStacktrace;
    private volatile int messageSizeViolations;
    private volatile int messagesSent;
    private volatile int messagesSentLastBatch;
    private volatile int messagesRequeuedLastBatch;

    public void setMessageQueue(MessageQueue messageQueue) {
        this.messageQueue = messageQueue;
    }

    public void setLastError(String message, Throwable error) {
        this.lastErrorTimestamp = new Date();
        this.lastError = error;
        String string = this.lastErrorMessage = message != null ? message : error.toString();
        if (error != null) {
            ArrayList<String> stacktrace = new ArrayList<String>();
            for (StackTraceElement ste : error.getStackTrace()) {
                stacktrace.add(ste.toString());
            }
            this.lastErrorStacktrace = stacktrace;
        } else {
            this.lastErrorStacktrace = null;
        }
    }

    public Throwable getLastError() {
        return this.lastError;
    }

    public String getLastErrorMessage() {
        return this.lastErrorMessage;
    }

    public Date getLastErrorTimestamp() {
        return this.lastErrorTimestamp;
    }

    public List<String> getLastErrorStacktrace() {
        return this.lastErrorStacktrace;
    }

    public synchronized void incrementOversizeMessages() {
        ++this.messageSizeViolations;
    }

    public int getOversizeMessages() {
        return this.messageSizeViolations;
    }

    public synchronized void updateMessagesSent(int count) {
        this.messagesSent += count;
    }

    public int getMessagesSent() {
        return this.messagesSent;
    }

    public void setMessagesSentLastBatch(int count) {
        this.messagesSentLastBatch = count;
    }

    public int getMessagesSentLastBatch() {
        return this.messagesSentLastBatch;
    }

    public void setMessagesRequeuedLastBatch(int count) {
        this.messagesRequeuedLastBatch = count;
    }

    public int getMessagesRequeuedLastBatch() {
        return this.messagesRequeuedLastBatch;
    }

    public int getMessagesDiscarded() {
        return this.messageQueue.getDroppedMessageCount();
    }
}

