/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.aws.internal.clientfactory;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.kdgregory.logging.aws.internal.Utils;
import com.kdgregory.logging.aws.internal.retrievers.AbstractReflectionBasedRetriever;
import com.kdgregory.logging.aws.internal.retrievers.RoleArnRetriever;
import com.kdgregory.logging.common.factories.ClientFactory;
import com.kdgregory.logging.common.factories.ClientFactoryException;
import com.kdgregory.logging.common.util.InternalLogger;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class BuilderClientFactory<ClientType>
implements ClientFactory<ClientType> {
    private Class<ClientType> clientType;
    private String builderClassName;
    private String assumedRole;
    private String region;
    private InternalLogger logger;
    private Class<?> builderClass;

    public BuilderClientFactory(Class<ClientType> clientType, String builderClassName, String assumedRole, String region, InternalLogger logger) {
        this.clientType = clientType;
        this.builderClassName = builderClassName;
        this.assumedRole = assumedRole;
        this.region = region;
        this.logger = logger;
        this.builderClass = Utils.loadClass(builderClassName);
    }

    @Override
    public ClientType createClient() {
        if (this.builderClass == null) {
            return null;
        }
        this.logger.debug("creating client via SDK builder");
        Object builder = this.createBuilder();
        this.maybeSetRegion(builder);
        this.setCredentialsProvider(builder);
        try {
            Method clientFactoryMethod = builder.getClass().getMethod("build", new Class[0]);
            return this.clientType.cast(clientFactoryMethod.invoke(builder, new Object[0]));
        }
        catch (Exception ex) {
            throw new ClientFactoryException("failed to invoke builder: " + this.builderClassName, ex);
        }
    }

    protected Object createBuilder() {
        try {
            Method method = this.builderClass.getDeclaredMethod("standard", new Class[0]);
            return method.invoke(null, new Object[0]);
        }
        catch (Exception ex) {
            throw new ClientFactoryException("failed to create builder", ex);
        }
    }

    protected void maybeSetRegion(Object builder) {
        if (this.region == null || this.region.isEmpty()) {
            return;
        }
        try {
            this.logger.debug("setting region: " + this.region);
            Utils.invokeSetter(builder, "setRegion", String.class, this.region);
        }
        catch (Throwable ex) {
            throw new ClientFactoryException("failed to set region: " + this.region, ex);
        }
    }

    protected void setCredentialsProvider(Object builder) {
        try {
            AWSCredentialsProvider credentialsProvider;
            if (this.assumedRole == null) {
                this.logger.debug("using default credentials provider");
                credentialsProvider = this.createDefaultCredentialsProvider();
            } else {
                this.logger.debug("assuming role " + this.assumedRole);
                credentialsProvider = this.createAssumedRoleCredentialsProvider();
            }
            Utils.invokeSetter(builder, "setCredentials", AWSCredentialsProvider.class, credentialsProvider);
        }
        catch (Throwable ex) {
            throw new ClientFactoryException("failed to set credentials provider", ex);
        }
    }

    protected AWSCredentialsProvider createDefaultCredentialsProvider() {
        AbstractReflectionBasedRetriever invoker = new AbstractReflectionBasedRetriever("com.amazonaws.auth.DefaultAWSCredentialsProviderChain");
        AWSCredentialsProvider provider = (AWSCredentialsProvider)invoker.invokeStatic(invoker.clientKlass, "getInstance", null, null);
        if (invoker.exception != null) {
            this.logger.error("failed to create default credentials provider", invoker.exception);
        }
        return provider;
    }

    protected AWSCredentialsProvider createAssumedRoleCredentialsProvider() {
        Object stsClient = new BuilderClientFactory<Object>(Object.class, "com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder", null, null, this.logger).createClient();
        String roleArn = new RoleArnRetriever().invoke(this.assumedRole);
        String sessionName = "com.kdgregory.logging.aws";
        AbstractReflectionBasedRetriever invoker = new AbstractReflectionBasedRetriever("com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider$Builder", "com.amazonaws.services.securitytoken.AWSSecurityTokenService", null);
        if (invoker.clientKlass == null) {
            throw new ClientFactoryException("failed to load STS credentials provider builder; check your dependencies");
        }
        try {
            Constructor<?> ctor = invoker.clientKlass.getConstructor(String.class, String.class);
            Object stsClientBuilder = ctor.newInstance(roleArn, sessionName);
            invoker.invokeMethod(invoker.clientKlass, stsClientBuilder, "withStsClient", invoker.requestKlass, stsClient);
            AWSCredentialsProvider provider = (AWSCredentialsProvider)invoker.invokeMethod(invoker.clientKlass, stsClientBuilder, "build", null, null);
            if (invoker.exception != null) {
                throw invoker.exception;
            }
            return provider;
        }
        catch (Throwable ex) {
            throw new ClientFactoryException("failed to create assumed-role credentials provider", ex);
        }
    }
}

