/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.aws.internal.clientfactory;

import com.amazonaws.regions.Regions;
import com.kdgregory.logging.aws.internal.Utils;
import com.kdgregory.logging.common.factories.ClientFactory;
import com.kdgregory.logging.common.factories.ClientFactoryException;
import com.kdgregory.logging.common.util.InternalLogger;

public class ConstructorClientFactory<ClientType>
implements ClientFactory<ClientType> {
    private Class<ClientType> clientType;
    private Class<?> clientClass;
    private String region;
    private String endpoint;
    private InternalLogger logger;

    public ConstructorClientFactory(Class<ClientType> clientType, String clientClassName, String region, String endpoint, InternalLogger logger) {
        this.clientType = clientType;
        this.region = region;
        this.endpoint = endpoint;
        this.logger = logger;
        this.clientClass = Utils.loadClass(clientClassName);
    }

    @Override
    public ClientType createClient() {
        this.logger.debug("creating client via constructor");
        ClientType client = this.invokeConstructor();
        if (this.maybeSetEndpoint(client)) {
            return client;
        }
        this.maybeSetRegion(client);
        return client;
    }

    protected ClientType invokeConstructor() {
        try {
            return this.clientType.cast(this.clientClass.newInstance());
        }
        catch (Exception ex) {
            throw new ClientFactoryException("failed to instantiate service client: " + this.clientClass, ex);
        }
    }

    protected boolean maybeSetEndpoint(ClientType client) {
        if (this.endpoint == null || this.endpoint.isEmpty()) {
            return false;
        }
        try {
            this.logger.debug("setting endpoint: " + this.endpoint);
            Utils.invokeSetter(client, "setEndpoint", String.class, this.endpoint);
            return true;
        }
        catch (Throwable ex) {
            throw new ClientFactoryException("failed to set endpoint: " + this.endpoint, ex);
        }
    }

    protected boolean maybeSetRegion(ClientType client) {
        String regionName = Utils.lookupRegion(this.region);
        if (regionName == null || regionName.isEmpty()) {
            return false;
        }
        this.logger.debug("setting region: " + regionName);
        try {
            Regions resolvedRegion = Regions.fromName((String)regionName);
            Utils.invokeSetter(client, "configureRegion", Regions.class, resolvedRegion);
            return true;
        }
        catch (Throwable ex) {
            throw new ClientFactoryException("failed to set region: " + regionName);
        }
    }
}

