/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.aws.internal.clientfactory;

import com.kdgregory.logging.aws.internal.Utils;
import com.kdgregory.logging.common.factories.ClientFactory;
import com.kdgregory.logging.common.factories.ClientFactoryException;
import com.kdgregory.logging.common.util.InternalLogger;
import java.lang.reflect.Method;

public class StaticMethodClientFactory<ClientType>
implements ClientFactory<ClientType> {
    private Class<ClientType> clientType;
    private String fullyQualifiedMethodName;
    private String assumedRole;
    private String region;
    private String endpoint;
    private InternalLogger logger;

    public StaticMethodClientFactory(Class<ClientType> clientType, String fullyQualifiedMethodName, String assumedRole, String region, String endpoint, InternalLogger logger) {
        this.clientType = clientType;
        this.fullyQualifiedMethodName = fullyQualifiedMethodName;
        this.assumedRole = assumedRole;
        this.region = region;
        this.endpoint = endpoint;
        this.logger = logger;
    }

    @Override
    public ClientType createClient() {
        Method factoryMethod;
        if (this.fullyQualifiedMethodName == null || this.fullyQualifiedMethodName.isEmpty()) {
            return null;
        }
        this.logger.debug("creating client via factory method: " + this.fullyQualifiedMethodName);
        try {
            factoryMethod = Utils.findFullyQualifiedMethod(this.fullyQualifiedMethodName, new Class[0]);
        }
        catch (Exception ignored) {
            try {
                factoryMethod = Utils.findFullyQualifiedMethod(this.fullyQualifiedMethodName, String.class, String.class, String.class);
            }
            catch (Exception ex) {
                throw new ClientFactoryException("invalid factory method: " + this.fullyQualifiedMethodName, ex);
            }
        }
        try {
            return factoryMethod.getParameterTypes().length == 0 ? this.clientType.cast(factoryMethod.invoke(null, new Object[0])) : this.clientType.cast(factoryMethod.invoke(null, this.assumedRole, this.region, this.endpoint));
        }
        catch (Exception ex) {
            throw new ClientFactoryException("factory method error: " + this.fullyQualifiedMethodName, ex);
        }
    }
}

