/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.log4j.aws;

import com.kdgregory.log4j.aws.internal.AbstractAppender;
import com.kdgregory.logging.aws.cloudwatch.CloudWatchConstants;
import com.kdgregory.logging.aws.cloudwatch.CloudWatchWriterConfig;
import com.kdgregory.logging.aws.cloudwatch.CloudWatchWriterFactory;
import com.kdgregory.logging.aws.cloudwatch.CloudWatchWriterStatistics;
import com.kdgregory.logging.aws.cloudwatch.CloudWatchWriterStatisticsMXBean;
import com.kdgregory.logging.aws.common.Substitutions;
import com.kdgregory.logging.common.util.DefaultThreadFactory;
import com.kdgregory.logging.common.util.ThreadFactory;
import java.util.Date;

public class CloudWatchAppender
extends AbstractAppender<CloudWatchWriterConfig, CloudWatchWriterStatistics, CloudWatchWriterStatisticsMXBean> {
    private String logGroup;
    private String logStream = "{startupTimestamp}";
    private Integer retentionPeriod;
    private boolean dedicatedWriter = true;

    public CloudWatchAppender() {
        super((ThreadFactory)new DefaultThreadFactory("log4j-cloudwatch"), new CloudWatchWriterFactory(), new CloudWatchWriterStatistics(), CloudWatchWriterStatisticsMXBean.class);
    }

    public void setLogGroup(String value) {
        this.logGroup = value;
    }

    public String getLogGroup() {
        return this.logGroup;
    }

    public void setLogStream(String value) {
        this.logStream = value;
    }

    public String getLogStream() {
        return this.logStream;
    }

    public void setRetentionPeriod(int value) {
        this.retentionPeriod = CloudWatchConstants.validateRetentionPeriod((Integer)value);
    }

    public int getRetentionPeriod() {
        return this.retentionPeriod == null ? 0 : this.retentionPeriod;
    }

    public void setDedicatedWriter(boolean value) {
        this.dedicatedWriter = value;
    }

    public boolean getDedicatedWriter() {
        return this.dedicatedWriter;
    }

    @Override
    protected CloudWatchWriterConfig generateWriterConfig() {
        Substitutions subs = new Substitutions(new Date(), 0);
        String actualLogGroup = subs.perform(this.logGroup);
        String actualLogStream = subs.perform(this.logStream);
        return new CloudWatchWriterConfig().setLogGroupName(actualLogGroup).setLogStreamName(actualLogStream).setRetentionPeriod(this.retentionPeriod).setDedicatedWriter(this.dedicatedWriter);
    }
}

