/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.log4j.aws;

import com.kdgregory.log4j.aws.internal.AbstractAppender;
import com.kdgregory.logging.aws.common.Substitutions;
import com.kdgregory.logging.aws.kinesis.KinesisWriterConfig;
import com.kdgregory.logging.aws.kinesis.KinesisWriterFactory;
import com.kdgregory.logging.aws.kinesis.KinesisWriterStatistics;
import com.kdgregory.logging.aws.kinesis.KinesisWriterStatisticsMXBean;
import com.kdgregory.logging.common.util.DefaultThreadFactory;
import com.kdgregory.logging.common.util.ThreadFactory;
import java.util.Date;

public class KinesisAppender
extends AbstractAppender<KinesisWriterConfig, KinesisWriterStatistics, KinesisWriterStatisticsMXBean> {
    private String streamName;
    private String partitionKey = "{startupTimestamp}";
    private boolean autoCreate;
    private int shardCount = 1;
    private Integer retentionPeriod;
    private String actualStreamName;
    private String actualPartitionKey;

    public KinesisAppender() {
        super((ThreadFactory)new DefaultThreadFactory("log4j-kinesis"), new KinesisWriterFactory(), new KinesisWriterStatistics(), KinesisWriterStatisticsMXBean.class);
    }

    public void setStreamName(String value) {
        if (this.actualStreamName != null) {
            throw new IllegalArgumentException("appender cannot be reconfigured after processing messages");
        }
        this.streamName = value;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public void setPartitionKey(String value) {
        if (this.actualStreamName != null) {
            throw new IllegalArgumentException("appender cannot be reconfigured after processing messages");
        }
        this.partitionKey = value;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }

    public void setAutoCreate(boolean autoCreate) {
        this.autoCreate = autoCreate;
    }

    public boolean isAutoCreate() {
        return this.autoCreate;
    }

    public void setShardCount(int shardCount) {
        this.shardCount = shardCount;
    }

    public int getShardCount() {
        return this.shardCount;
    }

    public void setRetentionPeriod(int value) {
        if (value <= 24 || value > 168) {
            throw new IllegalArgumentException("retentionPeriod must be between 25 and 168");
        }
        this.retentionPeriod = value;
    }

    public int getRetentionPeriod() {
        return this.retentionPeriod != null ? this.retentionPeriod : 24;
    }

    @Override
    protected KinesisWriterConfig generateWriterConfig() {
        Substitutions subs = new Substitutions(new Date(), 0);
        this.actualStreamName = subs.perform(this.streamName);
        this.actualPartitionKey = subs.perform(this.partitionKey);
        return new KinesisWriterConfig().setStreamName(this.actualStreamName).setPartitionKey(this.actualPartitionKey).setAutoCreate(this.autoCreate).setShardCount(this.shardCount).setRetentionPeriod(this.retentionPeriod);
    }
}

