/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.log4j.aws;

import com.kdgregory.log4j.aws.internal.AbstractAppender;
import com.kdgregory.logging.aws.common.Substitutions;
import com.kdgregory.logging.aws.sns.SNSWriterConfig;
import com.kdgregory.logging.aws.sns.SNSWriterFactory;
import com.kdgregory.logging.aws.sns.SNSWriterStatistics;
import com.kdgregory.logging.aws.sns.SNSWriterStatisticsMXBean;
import com.kdgregory.logging.common.util.DefaultThreadFactory;
import com.kdgregory.logging.common.util.ThreadFactory;
import java.util.Date;

public class SNSAppender
extends AbstractAppender<SNSWriterConfig, SNSWriterStatistics, SNSWriterStatisticsMXBean> {
    private String topicName;
    private String topicArn;
    private String subject;
    private boolean autoCreate;

    public SNSAppender() {
        super((ThreadFactory)new DefaultThreadFactory("log4j-sns"), new SNSWriterFactory(), new SNSWriterStatistics(), SNSWriterStatisticsMXBean.class);
        super.setDiscardThreshold(1000);
        super.setBatchDelay(1L);
    }

    public void setTopicName(String value) {
        this.topicName = value;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicArn(String value) {
        this.topicArn = value;
    }

    public String getTopicArn() {
        return this.topicArn;
    }

    public void setAutoCreate(boolean value) {
        this.autoCreate = value;
    }

    public boolean getAutoCreate() {
        return this.autoCreate;
    }

    public void setSubject(String value) {
        this.subject = value;
    }

    public String getSubject() {
        return this.subject;
    }

    @Override
    public void setBatchDelay(long value) {
        super.setBatchDelay(1L);
    }

    @Override
    protected SNSWriterConfig generateWriterConfig() {
        Substitutions subs = new Substitutions(new Date(), 0);
        String actualTopicName = subs.perform(this.topicName);
        String actualTopicArn = subs.perform(this.topicArn);
        String actualSubject = subs.perform(this.subject);
        return new SNSWriterConfig().setTopicName(actualTopicName).setTopicArn(actualTopicArn).setSubject(actualSubject).setAutoCreate(this.autoCreate);
    }
}

