/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.log4j.aws.internal;

import com.kdgregory.logging.common.LogMessage;
import java.io.IOException;
import java.io.StringWriter;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;

public class Utils {
    public static LogMessage convertToLogMessage(LoggingEvent event, Layout layout) {
        try {
            StringWriter out = new StringWriter(1024);
            out.write(layout.format(event));
            if (event.getThrowableInformation() != null && layout.ignoresThrowable()) {
                for (String traceline : event.getThrowableStrRep()) {
                    out.write(traceline);
                    out.write(Layout.LINE_SEP);
                }
            }
            out.close();
            return new LogMessage(event.getTimeStamp(), out.toString());
        }
        catch (IOException ex) {
            throw new RuntimeException("IOException from StringWriter");
        }
    }
}

