/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.log4j.aws;

import com.kdgregory.log4j.aws.internal.AbstractAppender;
import com.kdgregory.logging.aws.cloudwatch.CloudWatchConstants;
import com.kdgregory.logging.aws.cloudwatch.CloudWatchWriterConfig;
import com.kdgregory.logging.aws.cloudwatch.CloudWatchWriterFactory;
import com.kdgregory.logging.aws.cloudwatch.CloudWatchWriterStatistics;
import com.kdgregory.logging.aws.cloudwatch.CloudWatchWriterStatisticsMXBean;
import com.kdgregory.logging.aws.common.Substitutions;
import com.kdgregory.logging.common.util.DefaultThreadFactory;
import com.kdgregory.logging.common.util.ThreadFactory;
import java.util.Date;

public class CloudWatchAppender
extends AbstractAppender<CloudWatchWriterConfig, CloudWatchWriterStatistics, CloudWatchWriterStatisticsMXBean> {
    public CloudWatchAppender() {
        super(new CloudWatchWriterConfig(), (ThreadFactory)new DefaultThreadFactory("log4j-cloudwatch"), new CloudWatchWriterFactory(), new CloudWatchWriterStatistics(), CloudWatchWriterStatisticsMXBean.class);
    }

    public void setLogGroup(String value) {
        ((CloudWatchWriterConfig)this.appenderConfig).setLogGroupName(value);
    }

    public String getLogGroup() {
        return ((CloudWatchWriterConfig)this.appenderConfig).getLogGroupName();
    }

    public void setLogStream(String value) {
        ((CloudWatchWriterConfig)this.appenderConfig).setLogStreamName(value);
    }

    public String getLogStream() {
        return ((CloudWatchWriterConfig)this.appenderConfig).getLogStreamName();
    }

    public void setRetentionPeriod(int value) {
        ((CloudWatchWriterConfig)this.appenderConfig).setRetentionPeriod(CloudWatchConstants.validateRetentionPeriod((Integer)value));
    }

    public int getRetentionPeriod() {
        return ((CloudWatchWriterConfig)this.appenderConfig).getRetentionPeriod() == null ? 0 : ((CloudWatchWriterConfig)this.appenderConfig).getRetentionPeriod();
    }

    public void setDedicatedWriter(boolean value) {
        ((CloudWatchWriterConfig)this.appenderConfig).setDedicatedWriter(value);
    }

    public boolean getDedicatedWriter() {
        return ((CloudWatchWriterConfig)this.appenderConfig).getDedicatedWriter();
    }

    @Override
    protected CloudWatchWriterConfig generateWriterConfig() {
        Substitutions subs = new Substitutions(new Date(), 0);
        String actualLogGroup = subs.perform(this.getLogGroup());
        String actualLogStream = subs.perform(this.getLogStream());
        return ((CloudWatchWriterConfig)((CloudWatchWriterConfig)this.appenderConfig).clone()).setLogGroupName(actualLogGroup).setLogStreamName(actualLogStream);
    }
}

