/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.log4j.aws;

import com.kdgregory.logging.aws.common.Substitutions;
import com.kdgregory.logging.common.internal.JsonConverter;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;

public class JsonLayout
extends Layout {
    private String processId;
    private String hostname;
    private String instanceId;
    private String accountId;
    private Map<String, String> tags;
    private boolean enableHostname = true;
    private boolean appendNewlines;
    private boolean enableLocation;
    private boolean enableInstanceId;
    private boolean enableAccountId;
    private String rawTags;

    public void setAppendNewlines(boolean value) {
        this.appendNewlines = value;
    }

    public boolean getAppendNewlines() {
        return this.appendNewlines;
    }

    public void setEnableLocation(boolean value) {
        this.enableLocation = value;
    }

    public boolean getEnableLocation() {
        return this.enableLocation;
    }

    public void setEnableInstanceId(boolean value) {
        this.enableInstanceId = value;
    }

    public boolean getEnableInstanceId() {
        return this.enableInstanceId;
    }

    public boolean getEnableAccountId() {
        return this.enableAccountId;
    }

    public void setEnableAccountId(boolean enableAccountId) {
        this.enableAccountId = enableAccountId;
    }

    public void setEnableHostname(boolean value) {
        this.enableHostname = value;
    }

    public boolean getEnableHostname() {
        return this.enableHostname;
    }

    public void setTags(String value) {
        this.rawTags = value;
    }

    public String getTags() {
        return this.rawTags;
    }

    public void activateOptions() {
        Substitutions subs = new Substitutions(new Date(), 0);
        this.processId = subs.perform("{pid}");
        if ("unknown".equals(this.processId)) {
            this.processId = null;
        }
        if (this.enableHostname) {
            this.hostname = subs.perform("{hostname}");
            if ("unknown".equals(this.hostname)) {
                this.hostname = null;
            }
        }
        if (this.enableInstanceId) {
            this.instanceId = subs.perform("{instanceId}");
            if ("{instanceId}".equals(this.instanceId)) {
                this.instanceId = null;
            }
        }
        if (this.enableAccountId) {
            this.accountId = subs.perform("{aws:accountId}");
            if ("unknown-account".equals(this.accountId)) {
                this.accountId = null;
            }
        }
        if (this.rawTags != null && !this.rawTags.isEmpty()) {
            this.tags = new TreeMap<String, String>();
            for (String tagdef : this.rawTags.split(",")) {
                String[] splitdef = tagdef.split("=");
                if (splitdef.length != 2) {
                    throw new IllegalArgumentException("invalid tag definition: " + tagdef);
                }
                this.tags.put(splitdef[0], subs.perform(splitdef[1]));
            }
        }
    }

    public String format(LoggingEvent event) {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        map.put("timestamp", new Date(event.getTimeStamp()));
        map.put("thread", event.getThreadName());
        map.put("logger", event.getLogger().getName());
        map.put("level", event.getLevel().toString());
        map.put("message", event.getRenderedMessage());
        if (event.getNDC() != null) {
            map.put("ndc", event.getNDC());
        }
        if (this.tags != null) {
            map.put("tags", this.tags);
        }
        if (this.processId != null) {
            map.put("processId", this.processId);
        }
        if (this.hostname != null) {
            map.put("hostname", this.hostname);
        }
        if (this.instanceId != null) {
            map.put("instanceId", this.instanceId);
        }
        if (this.accountId != null) {
            map.put("accountId", this.accountId);
        }
        if (event.getProperties() != null && !event.getProperties().isEmpty()) {
            map.put("mdc", event.getProperties());
        }
        if (event.getThrowableStrRep() != null) {
            String[] trace = event.getThrowableStrRep();
            for (int ii = 0; ii < trace.length; ++ii) {
                trace[ii] = trace[ii].replace("\t", "");
            }
            map.put("exception", trace);
        }
        if (this.enableLocation) {
            LocationInfo info = event.getLocationInformation();
            TreeMap<String, String> location = new TreeMap<String, String>();
            location.put("className", info.getClassName());
            location.put("methodName", info.getMethodName());
            location.put("fileName", info.getFileName());
            location.put("lineNumber", info.getLineNumber());
            map.put("locationInfo", location);
        }
        String json = new JsonConverter().convert(map);
        if (this.getAppendNewlines()) {
            json = json + "\n";
        }
        return json;
    }

    public boolean ignoresThrowable() {
        return false;
    }
}

