/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.log4j.aws.internal;

import com.kdgregory.log4j.aws.internal.JMXManager;
import com.kdgregory.log4j.aws.internal.Log4JInternalLogger;
import com.kdgregory.log4j.aws.internal.Utils;
import com.kdgregory.logging.aws.internal.AbstractWriterConfig;
import com.kdgregory.logging.aws.internal.AbstractWriterStatistics;
import com.kdgregory.logging.common.LogMessage;
import com.kdgregory.logging.common.LogWriter;
import com.kdgregory.logging.common.util.InternalLogger;
import com.kdgregory.logging.common.util.MessageQueue;
import com.kdgregory.logging.common.util.ThreadFactory;
import com.kdgregory.logging.common.util.WriterFactory;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

public abstract class AbstractAppender<WriterConfigType extends AbstractWriterConfig<WriterConfigType>, AppenderStatsType extends AbstractWriterStatistics, AppenderStatsMXBeanType>
extends AppenderSkeleton {
    private volatile boolean ready = false;
    private volatile boolean closed = false;
    protected ThreadFactory threadFactory;
    protected WriterFactory<WriterConfigType, AppenderStatsType> writerFactory;
    protected Log4JInternalLogger internalLogger;
    protected AppenderStatsType appenderStats;
    private Class<AppenderStatsMXBeanType> appenderStatsMXBeanClass;
    protected volatile LogWriter writer;
    private Object initializationLock = new Object();
    protected WriterConfigType appenderConfig;

    public AbstractAppender(WriterConfigType appenderConfig, ThreadFactory threadFactory, WriterFactory<WriterConfigType, AppenderStatsType> writerFactory, AppenderStatsType appenderStats, Class<AppenderStatsMXBeanType> appenderStatsMXBeanClass) {
        this.appenderConfig = appenderConfig;
        this.threadFactory = threadFactory;
        this.writerFactory = writerFactory;
        this.appenderStats = appenderStats;
        this.appenderStatsMXBeanClass = appenderStatsMXBeanClass;
        this.internalLogger = new Log4JInternalLogger(((Object)((Object)this)).getClass().getSimpleName());
    }

    public void setSynchronous(boolean value) {
        if (this.writer != null) {
            throw new IllegalStateException("can not set synchronous mode once writer created");
        }
        this.appenderConfig.setSynchronousMode(value);
    }

    public boolean getSynchronous() {
        return this.appenderConfig.getSynchronousMode();
    }

    public void setBatchDelay(long value) {
        this.appenderConfig.setBatchDelay(value);
        if (this.writer != null) {
            this.writer.setBatchDelay(value);
        }
    }

    public long getBatchDelay() {
        return this.appenderConfig.getBatchDelay();
    }

    public void setTruncateOversizeMessages(boolean value) {
        this.appenderConfig.setTruncateOversizeMessages(value);
    }

    public boolean getTruncateOversizeMessages() {
        return this.appenderConfig.getTruncateOversizeMessages();
    }

    public void setDiscardThreshold(int value) {
        this.appenderConfig.setDiscardThreshold(value);
        if (this.writer != null) {
            this.writer.setDiscardThreshold(value);
        }
    }

    public int getDiscardThreshold() {
        return this.appenderConfig.getDiscardThreshold();
    }

    public void setDiscardAction(String value) {
        MessageQueue.DiscardAction tmpDiscardAction = MessageQueue.DiscardAction.lookup((String)value);
        if (tmpDiscardAction == null) {
            this.internalLogger.error("invalid discard action: " + value, null);
            return;
        }
        this.appenderConfig.setDiscardAction(tmpDiscardAction);
        if (this.writer != null) {
            this.writer.setDiscardAction(tmpDiscardAction);
        }
    }

    public String getDiscardAction() {
        return this.appenderConfig.getDiscardAction().toString();
    }

    public void setAssumedRole(String value) {
        this.appenderConfig.setAssumedRole(value);
    }

    public String getAssumedRole() {
        return this.appenderConfig.getAssumedRole();
    }

    public void setClientFactory(String value) {
        this.appenderConfig.setClientFactoryMethod(value);
    }

    public String getClientFactory() {
        return this.appenderConfig.getClientFactoryMethod();
    }

    public void setClientRegion(String value) {
        this.appenderConfig.setClientRegion(value);
    }

    public String getClientRegion() {
        return this.appenderConfig.getClientRegion();
    }

    public void setClientEndpoint(String value) {
        this.appenderConfig.setClientEndpoint(value);
    }

    public String getClientEndpoint() {
        return this.appenderConfig.getClientEndpoint();
    }

    public void setUseShutdownHook(boolean value) {
        this.appenderConfig.setUseShutdownHook(value);
    }

    public boolean getUseShutdownHook() {
        return this.appenderConfig.getUseShutdownHook();
    }

    public void setInitializationTimeout(long value) {
        this.appenderConfig.setInitializationTimeout(value);
    }

    public long getInitializationTimeout() {
        return this.appenderConfig.getInitializationTimeout();
    }

    public void setEnableBatchLogging(boolean value) {
        this.appenderConfig.setEnableBatchLogging(value);
    }

    public boolean getEnableBatchLogging() {
        return this.appenderConfig.getEnableBatchLogging();
    }

    public AppenderStatsType getAppenderStatistics() {
        return this.appenderStats;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setName(String name) {
        super.setName(name);
        this.internalLogger.setAppenderName(name);
    }

    protected void append(LoggingEvent event) {
        LogMessage logMessage;
        if (this.closed) {
            throw new IllegalStateException("appender is closed");
        }
        if (!this.ready) {
            this.initialize();
        }
        try {
            logMessage = Utils.convertToLogMessage(event, this.getLayout());
        }
        catch (Exception ex) {
            this.internalLogger.error("unable to apply layout", ex);
            return;
        }
        try {
            this.internalAppend(logMessage);
        }
        catch (Exception ex) {
            this.internalLogger.error("unable to append event", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.initializationLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.stopWriter();
            this.unregisterStatisticsBean();
            this.closed = true;
        }
    }

    public boolean requiresLayout() {
        return true;
    }

    protected abstract WriterConfigType generateWriterConfig();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        Object object = this.initializationLock;
        synchronized (object) {
            if (this.ready) {
                return;
            }
            this.startWriter();
            this.registerStatisticsBean();
            this.ready = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWriter() {
        WriterConfigType actualConfig = this.generateWriterConfig();
        Object object = this.initializationLock;
        synchronized (object) {
            try {
                this.writer = this.writerFactory.newLogWriter(actualConfig, this.appenderStats, (InternalLogger)this.internalLogger);
                this.threadFactory.startWriterThread(this.writer, new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread t, Throwable ex) {
                        AbstractAppender.this.internalLogger.error("unhandled exception in writer", ex);
                        AbstractAppender.this.appenderStats.setLastError(null, ex);
                        AbstractAppender.this.writer = null;
                    }
                });
                if (this.layout.getHeader() != null) {
                    this.internalAppend(new LogMessage(System.currentTimeMillis(), this.layout.getHeader()));
                }
            }
            catch (Exception ex) {
                this.internalLogger.error("exception while initializing writer", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopWriter() {
        Object object = this.initializationLock;
        synchronized (object) {
            try {
                if (this.writer == null) {
                    return;
                }
                if (this.layout.getFooter() != null) {
                    this.internalAppend(new LogMessage(System.currentTimeMillis(), this.layout.getFooter()));
                }
                this.writer.stop();
                this.writer.waitUntilStopped(this.appenderConfig.getBatchDelay() * 2L);
            }
            catch (Exception ex) {
                this.internalLogger.error("exception while shutting down writer", ex);
            }
            this.writer = null;
        }
    }

    protected void registerStatisticsBean() {
        JMXManager.getInstance().addStatsBean(this.getName(), (AbstractWriterStatistics)this.appenderStats, this.appenderStatsMXBeanClass);
    }

    protected void unregisterStatisticsBean() {
        JMXManager.getInstance().removeStatsBean(this.getName());
    }

    private void internalAppend(LogMessage message) {
        if (message == null) {
            this.internalLogger.error("internal error: message was null", null);
            return;
        }
        this.writer.addMessage(message);
    }
}

