/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.log4j.aws.internal;

import com.kdgregory.logging.common.util.InternalLogger;
import org.apache.log4j.helpers.LogLog;

public class Log4JInternalLogger
implements InternalLogger {
    private String appenderType;
    private String messagePrefix;

    public Log4JInternalLogger(String appenderType) {
        this.appenderType = appenderType;
        this.messagePrefix = appenderType + ": ";
    }

    public void setAppenderName(String name) {
        if (name != null && !name.isEmpty()) {
            this.messagePrefix = this.appenderType + "(" + name + "): ";
        }
    }

    public void debug(String message) {
        LogLog.debug((String)(this.messagePrefix + message));
    }

    public void warn(String message) {
        LogLog.warn((String)(this.messagePrefix + message));
    }

    public void warn(String message, Throwable ex) {
        LogLog.warn((String)(this.messagePrefix + message), (Throwable)ex);
    }

    public void error(String message, Throwable ex) {
        if (ex != null) {
            LogLog.error((String)(this.messagePrefix + message), (Throwable)ex);
        } else {
            LogLog.error((String)(this.messagePrefix + message));
        }
    }
}

