/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.log4j2.aws;

import com.kdgregory.log4j2.aws.internal.AbstractAppender;
import com.kdgregory.log4j2.aws.internal.AbstractAppenderBuilder;
import com.kdgregory.log4j2.aws.internal.CloudWatchAppenderConfig;
import com.kdgregory.logging.aws.cloudwatch.CloudWatchConstants;
import com.kdgregory.logging.aws.cloudwatch.CloudWatchWriterConfig;
import com.kdgregory.logging.aws.cloudwatch.CloudWatchWriterFactory;
import com.kdgregory.logging.aws.cloudwatch.CloudWatchWriterStatistics;
import com.kdgregory.logging.aws.cloudwatch.CloudWatchWriterStatisticsMXBean;
import com.kdgregory.logging.aws.common.Substitutions;
import com.kdgregory.logging.common.factories.DefaultThreadFactory;
import com.kdgregory.logging.common.factories.ThreadFactory;
import com.kdgregory.logging.common.util.InternalLogger;
import com.kdgregory.logging.common.util.RotationMode;
import java.util.Date;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.core.util.Builder;

@Plugin(name="CloudWatchAppender", category="Core", elementType="appender")
public class CloudWatchAppender
extends AbstractAppender<CloudWatchAppenderConfig, CloudWatchWriterStatistics, CloudWatchWriterStatisticsMXBean, CloudWatchWriterConfig> {
    protected Integer retentionPeriod;

    @PluginBuilderFactory
    public static CloudWatchAppenderBuilder newBuilder() {
        return new CloudWatchAppenderBuilder();
    }

    protected CloudWatchAppender(String name, CloudWatchAppenderConfig config, InternalLogger internalLogger) {
        super(name, (ThreadFactory)new DefaultThreadFactory("log4j2-cloudwatch"), new CloudWatchWriterFactory(), new CloudWatchWriterStatistics(), CloudWatchWriterStatisticsMXBean.class, config, internalLogger);
        try {
            this.retentionPeriod = CloudWatchConstants.validateRetentionPeriod((Integer)config.getRetentionPeriod());
        }
        catch (IllegalArgumentException ex) {
            internalLogger.error(ex.getMessage(), null);
        }
    }

    @Override
    protected void rotate() {
        super.rotate();
    }

    @Override
    protected CloudWatchWriterConfig generateWriterConfig() {
        StrSubstitutor l4jsubs = ((CloudWatchAppenderConfig)this.config).getConfiguration().getStrSubstitutor();
        Substitutions subs = new Substitutions(new Date(), this.sequence.get());
        String actualLogGroup = subs.perform(l4jsubs.replace(((CloudWatchAppenderConfig)this.config).getLogGroup()));
        String actualLogStream = subs.perform(l4jsubs.replace(((CloudWatchAppenderConfig)this.config).getLogStream()));
        return new CloudWatchWriterConfig(actualLogGroup, actualLogStream, this.retentionPeriod, ((CloudWatchAppenderConfig)this.config).isDedicatedWriter(), ((CloudWatchAppenderConfig)this.config).getBatchDelay(), ((CloudWatchAppenderConfig)this.config).getDiscardThreshold(), this.discardAction, ((CloudWatchAppenderConfig)this.config).getClientFactory(), ((CloudWatchAppenderConfig)this.config).getAssumedRole(), ((CloudWatchAppenderConfig)this.config).getClientRegion(), ((CloudWatchAppenderConfig)this.config).getClientEndpoint());
    }

    public static class CloudWatchAppenderBuilder
    extends AbstractAppenderBuilder<CloudWatchAppenderBuilder>
    implements CloudWatchAppenderConfig,
    Builder<CloudWatchAppender> {
        @PluginBuilderAttribute(value="name")
        @Required(message="CloudWatchAppender: no name provided")
        private String name;
        @PluginBuilderAttribute(value="logGroup")
        private String logGroup;
        @PluginBuilderAttribute(value="logStream")
        private String logStream = "{startupTimestamp}";
        @PluginBuilderAttribute(value="retentionPeriod")
        private Integer retentionPeriod;
        @PluginBuilderAttribute(value="dedicatedWriter")
        private boolean dedicatedWriter;
        @PluginBuilderAttribute(value="rotationMode")
        private String rotationMode = RotationMode.none.name();
        @PluginBuilderAttribute(value="rotationInterval")
        private long rotationInterval = -1L;
        @PluginBuilderAttribute(value="sequence")
        private int sequence;

        @Override
        public String getName() {
            return this.name;
        }

        public CloudWatchAppenderBuilder setName(String value) {
            this.name = value;
            return this;
        }

        public CloudWatchAppenderBuilder setLogGroup(String value) {
            this.logGroup = value;
            return this;
        }

        @Override
        public String getLogGroup() {
            return this.logGroup;
        }

        public CloudWatchAppenderBuilder setLogStream(String value) {
            this.logStream = value;
            return this;
        }

        @Override
        public String getLogStream() {
            return this.logStream;
        }

        public CloudWatchAppenderBuilder setRetentionPeriod(Integer value) {
            this.retentionPeriod = value;
            return this;
        }

        @Override
        public Integer getRetentionPeriod() {
            return this.retentionPeriod;
        }

        public CloudWatchAppenderBuilder setDedicatedWriter(boolean value) {
            this.dedicatedWriter = value;
            return this;
        }

        @Override
        public boolean isDedicatedWriter() {
            return this.dedicatedWriter;
        }

        public CloudWatchAppenderBuilder setRotationMode(String value) {
            this.rotationMode = value;
            return this;
        }

        @Override
        public String getRotationMode() {
            return this.rotationMode;
        }

        public CloudWatchAppenderBuilder setRotationInterval(long value) {
            this.rotationInterval = value;
            return this;
        }

        @Override
        public long getRotationInterval() {
            return this.rotationInterval;
        }

        public CloudWatchAppenderBuilder setSequence(int value) {
            this.sequence = value;
            return this;
        }

        @Override
        public int getSequence() {
            return this.sequence;
        }

        public CloudWatchAppender build() {
            return new CloudWatchAppender(this.name, this, null);
        }
    }
}

