/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.log4j2.aws;

import com.kdgregory.logging.aws.common.Substitutions;
import java.util.Date;
import java.util.HashMap;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.lookup.StrLookup;

@Plugin(category="Lookup", name="awslogs")
public class Lookups
implements StrLookup {
    private static HashMap<String, String> lookup2sub = new HashMap();
    private Substitutions substitutions = new Substitutions(new Date(), 0);

    public String lookup(String key) {
        String result;
        String sub = lookup2sub.get(key);
        if (sub == null) {
            sub = "{" + key + "}";
        }
        if (sub.equals(result = this.substitutions.perform(sub))) {
            result = null;
        }
        return result;
    }

    public String lookup(LogEvent event, String key) {
        return this.lookup(key);
    }

    static {
        lookup2sub.put("awsAccountId", "{aws:accountId}");
        lookup2sub.put("ec2InstanceId", "{ec2:instanceId}");
        lookup2sub.put("ec2Region", "{ec2:region}");
    }
}

