/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.log4j2.aws.internal;

import com.kdgregory.log4j2.aws.internal.AbstractAppenderConfig;
import com.kdgregory.log4j2.aws.internal.JMXManager;
import com.kdgregory.log4j2.aws.internal.Log4J2InternalLogger;
import com.kdgregory.logging.aws.internal.AbstractWriterStatistics;
import com.kdgregory.logging.common.LogMessage;
import com.kdgregory.logging.common.LogWriter;
import com.kdgregory.logging.common.factories.ThreadFactory;
import com.kdgregory.logging.common.factories.WriterFactory;
import com.kdgregory.logging.common.util.DiscardAction;
import com.kdgregory.logging.common.util.InternalLogger;
import com.kdgregory.logging.common.util.RotationMode;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.StringLayout;

public abstract class AbstractAppender<AppenderConfigType extends AbstractAppenderConfig, AppenderStatsType extends AbstractWriterStatistics, AppenderStatsMXBeanType, WriterConfigType>
extends org.apache.logging.log4j.core.appender.AbstractAppender {
    protected ThreadFactory threadFactory;
    protected WriterFactory<WriterConfigType, AppenderStatsType> writerFactory;
    protected InternalLogger internalLogger;
    protected AppenderStatsType appenderStats;
    private Class<AppenderStatsMXBeanType> appenderStatsMXBeanClass;
    protected volatile long lastRotationTimestamp;
    protected volatile int messagesSinceLastRotation;
    protected AtomicInteger sequence = new AtomicInteger();
    private Object initializationLock = new Object();
    private Object appendLock = new Object();
    protected AppenderConfigType config;
    protected Charset layoutCharset = StandardCharsets.UTF_8;
    protected DiscardAction discardAction;
    protected RotationMode rotationMode;
    protected long rotationInterval;
    protected volatile LogWriter writer;

    protected AbstractAppender(String name, ThreadFactory threadFactory, WriterFactory<WriterConfigType, AppenderStatsType> writerFactory, AppenderStatsType appenderStats, Class<AppenderStatsMXBeanType> appenderStatsMXBeanClass, AppenderConfigType config, InternalLogger providedInternalLogger) {
        super(name, config.getFilter(), config.getLayout());
        this.config = config;
        this.threadFactory = threadFactory;
        this.writerFactory = writerFactory;
        this.appenderStats = appenderStats;
        this.appenderStatsMXBeanClass = appenderStatsMXBeanClass;
        this.internalLogger = providedInternalLogger != null ? providedInternalLogger : new Log4J2InternalLogger(this);
        this.sequence.set(config.getSequence());
        this.discardAction = DiscardAction.lookup((String)config.getDiscardAction());
        if (this.discardAction == null) {
            this.internalLogger.error("invalid discard action: " + config.getDiscardAction(), null);
            this.discardAction = DiscardAction.oldest;
        }
        this.rotationMode = RotationMode.lookup((String)config.getRotationMode());
        if (this.rotationMode == null) {
            this.internalLogger.error("invalid rotation mode: " + config.getRotationMode(), null);
            this.rotationMode = RotationMode.none;
        }
        this.rotationInterval = config.getRotationInterval();
        Layout<String> layout = config.getLayout();
        if (layout instanceof StringLayout) {
            this.layoutCharset = ((StringLayout)layout).getCharset();
        }
    }

    public AppenderStatsType getAppenderStatistics() {
        return this.appenderStats;
    }

    public AppenderConfigType getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.initializationLock;
        synchronized (object) {
            if (this.isStarted()) {
                return;
            }
            this.startWriter();
            this.registerStatisticsBean();
        }
        super.start();
    }

    public void stop() {
        throw new IllegalStateException("stop() called -- should never happen with Log4J > 2.8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop(long timeout, TimeUnit timeUnit) {
        Object object = this.initializationLock;
        synchronized (object) {
            if (this.writer != null) {
                this.stopWriter(timeout, timeUnit);
            }
            this.unregisterStatisticsBean();
        }
        return super.stop(timeout, timeUnit);
    }

    public void append(LogEvent event) {
        if (!this.isStarted()) {
            this.internalLogger.warn("append called before appender was started");
            return;
        }
        String message = null;
        try {
            message = (String)((Object)this.getConfig().getLayout().toSerializable(event));
        }
        catch (Exception ex) {
            this.internalLogger.error("unable to apply layout", (Throwable)ex);
            return;
        }
        try {
            this.internalAppend(new LogMessage(event.getTimeMillis(), message));
        }
        catch (Exception ex) {
            this.internalLogger.error("unable to append event", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rotate() {
        Object object = this.initializationLock;
        synchronized (object) {
            this.stopWriter(0L, null);
            this.sequence.incrementAndGet();
            this.startWriter();
        }
    }

    protected abstract WriterConfigType generateWriterConfig();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWriter() {
        Object object = this.initializationLock;
        synchronized (object) {
            try {
                String header;
                this.writer = this.writerFactory.newLogWriter(this.generateWriterConfig(), this.appenderStats, this.internalLogger);
                if (this.config.isSynchronous()) {
                    this.writer.initialize();
                } else {
                    this.threadFactory.startLoggingThread(this.writer, false, new Thread.UncaughtExceptionHandler(){

                        @Override
                        public void uncaughtException(Thread t, Throwable ex) {
                            AbstractAppender.this.internalLogger.error("unhandled exception in writer", ex);
                            AbstractAppender.this.appenderStats.setLastError(null, ex);
                            AbstractAppender.this.writer = null;
                        }
                    });
                    if (!this.writer.waitUntilInitialized(60000L)) {
                        this.internalLogger.error("writer initialization timed out", null);
                    }
                }
                if (this.getLayout().getHeader() != null && (header = new String(this.getLayout().getHeader(), this.layoutCharset)).length() > 0) {
                    this.internalAppend(new LogMessage(System.currentTimeMillis(), header));
                }
                this.lastRotationTimestamp = System.currentTimeMillis();
                this.messagesSinceLastRotation = 0;
            }
            catch (Exception ex) {
                this.internalLogger.error("exception while initializing writer", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopWriter(long timeout, TimeUnit timeUnit) {
        Object object = this.initializationLock;
        synchronized (object) {
            try {
                String header;
                if (this.writer == null) {
                    return;
                }
                if (this.getLayout().getFooter() != null && (header = new String(this.getLayout().getFooter(), this.layoutCharset)).length() > 0) {
                    this.internalAppend(new LogMessage(System.currentTimeMillis(), header));
                }
                this.writer.stop();
                if (this.config.isSynchronous()) {
                    this.writer.cleanup();
                }
                if (timeUnit != null) {
                    this.writer.waitUntilStopped(timeUnit.toMillis(timeout));
                }
            }
            catch (Exception ex) {
                this.internalLogger.error("exception while shutting down writer", (Throwable)ex);
            }
            this.writer = null;
        }
    }

    protected void registerStatisticsBean() {
        JMXManager.getInstance().addStatsBean(this.getName(), (AbstractWriterStatistics)this.appenderStats, this.appenderStatsMXBeanClass);
    }

    protected void unregisterStatisticsBean() {
        JMXManager.getInstance().removeStatsBean(this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalAppend(LogMessage message) {
        if (message == null) {
            this.internalLogger.error("internal error: message was null", null);
            return;
        }
        Object object = this.appendLock;
        synchronized (object) {
            long now = System.currentTimeMillis();
            if (this.shouldRotate(now)) {
                long secondsSinceLastRotation = (now - this.lastRotationTimestamp) / 1000L;
                this.internalLogger.debug("rotating: messagesSinceLastRotation = " + this.messagesSinceLastRotation + ", secondsSinceLastRotation = " + secondsSinceLastRotation);
                this.rotate();
                if (this.writer == null) {
                    this.internalLogger.error("failed to rotate writer", null);
                    return;
                }
            }
            if (this.writer.isMessageTooLarge(message)) {
                this.internalLogger.warn("attempted to append a message > AWS batch size; ignored");
                return;
            }
            this.writer.addMessage(message);
            ++this.messagesSinceLastRotation;
        }
        if (this.getConfig().isSynchronous()) {
            this.writer.processBatch(System.currentTimeMillis());
        }
    }

    protected boolean shouldRotate(long now) {
        switch (this.rotationMode) {
            case none: {
                return false;
            }
            case count: {
                return this.rotationInterval > 0L && (long)this.messagesSinceLastRotation >= this.rotationInterval;
            }
            case interval: {
                return this.rotationInterval > 0L && now - this.lastRotationTimestamp > this.rotationInterval;
            }
            case hourly: {
                return this.lastRotationTimestamp / 3600000L < now / 3600000L;
            }
            case daily: {
                return this.lastRotationTimestamp / 86400000L < now / 86400000L;
            }
        }
        return false;
    }
}

