/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.log4j2.aws;

import com.kdgregory.log4j2.aws.internal.AbstractAppender;
import com.kdgregory.log4j2.aws.internal.AbstractAppenderBuilder;
import com.kdgregory.log4j2.aws.internal.SNSAppenderConfig;
import com.kdgregory.logging.aws.common.Substitutions;
import com.kdgregory.logging.aws.sns.SNSWriterConfig;
import com.kdgregory.logging.aws.sns.SNSWriterFactory;
import com.kdgregory.logging.aws.sns.SNSWriterStatistics;
import com.kdgregory.logging.aws.sns.SNSWriterStatisticsMXBean;
import com.kdgregory.logging.common.factories.DefaultThreadFactory;
import com.kdgregory.logging.common.factories.ThreadFactory;
import com.kdgregory.logging.common.util.InternalLogger;
import java.util.Date;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.core.util.Builder;

@Plugin(name="SNSAppender", category="Core", elementType="appender")
public class SNSAppender
extends AbstractAppender<SNSAppenderConfig, SNSWriterStatistics, SNSWriterStatisticsMXBean, SNSWriterConfig> {
    protected Integer retentionPeriod;

    @PluginBuilderFactory
    public static SNSAppenderBuilder newBuilder() {
        return new SNSAppenderBuilder();
    }

    protected SNSAppender(String name, SNSAppenderConfig config, InternalLogger internalLogger) {
        super(name, (ThreadFactory)new DefaultThreadFactory("log4j2-kinesis"), new SNSWriterFactory(), new SNSWriterStatistics(), SNSWriterStatisticsMXBean.class, config, internalLogger);
    }

    @Override
    protected SNSWriterConfig generateWriterConfig() {
        StrSubstitutor l4jsubs = ((SNSAppenderConfig)this.config).getConfiguration().getStrSubstitutor();
        Substitutions subs = new Substitutions(new Date(), this.sequence.get());
        String actualTopicName = subs.perform(l4jsubs.replace(((SNSAppenderConfig)this.config).getTopicName()));
        String actualTopicArn = subs.perform(l4jsubs.replace(((SNSAppenderConfig)this.config).getTopicArn()));
        String actualSubject = subs.perform(l4jsubs.replace(((SNSAppenderConfig)this.config).getSubject()));
        return new SNSWriterConfig(actualTopicName, actualTopicArn, actualSubject, ((SNSAppenderConfig)this.config).isAutoCreate(), false, ((SNSAppenderConfig)this.config).getDiscardThreshold(), this.discardAction, ((SNSAppenderConfig)this.config).getClientFactory(), ((SNSAppenderConfig)this.config).getAssumedRole(), ((SNSAppenderConfig)this.config).getClientRegion(), ((SNSAppenderConfig)this.config).getClientEndpoint());
    }

    @Override
    protected boolean shouldRotate(long now) {
        return false;
    }

    public static class SNSAppenderBuilder
    extends AbstractAppenderBuilder<SNSAppenderBuilder>
    implements SNSAppenderConfig,
    Builder<SNSAppender> {
        @PluginBuilderAttribute(value="name")
        @Required(message="SNSAppender: no name provided")
        private String name;
        @PluginBuilderAttribute(value="topicName")
        private String topicName;
        @PluginBuilderAttribute(value="topicArn")
        private String topicArn;
        @PluginBuilderAttribute(value="autoCreate")
        private boolean autoCreate;
        @PluginBuilderAttribute(value="subject")
        private String subject;

        public SNSAppenderBuilder() {
            this.setDiscardThreshold(1000);
        }

        public SNSAppenderBuilder setName(String value) {
            this.name = value;
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public SNSAppenderBuilder setTopicName(String value) {
            this.topicName = value;
            return this;
        }

        @Override
        public String getTopicName() {
            return this.topicName;
        }

        public SNSAppenderBuilder setTopicArn(String value) {
            this.topicArn = value;
            return this;
        }

        @Override
        public String getTopicArn() {
            return this.topicArn;
        }

        public SNSAppenderBuilder setAutoCreate(boolean value) {
            this.autoCreate = value;
            return this;
        }

        @Override
        public boolean isAutoCreate() {
            return this.autoCreate;
        }

        public SNSAppenderBuilder setSubject(String value) {
            this.subject = value;
            return this;
        }

        @Override
        public String getSubject() {
            return this.subject;
        }

        @Override
        public long getBatchDelay() {
            long value = super.getBatchDelay();
            return value == 0L ? 0L : 1L;
        }

        public SNSAppender build() {
            return new SNSAppender(this.name, this, null);
        }
    }
}

