/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.log4j2.aws;

import com.kdgregory.log4j2.aws.internal.AbstractAppender;
import com.kdgregory.log4j2.aws.internal.AbstractAppenderBuilder;
import com.kdgregory.log4j2.aws.internal.KinesisAppenderConfig;
import com.kdgregory.logging.aws.common.Substitutions;
import com.kdgregory.logging.aws.kinesis.KinesisWriterConfig;
import com.kdgregory.logging.aws.kinesis.KinesisWriterFactory;
import com.kdgregory.logging.aws.kinesis.KinesisWriterStatistics;
import com.kdgregory.logging.aws.kinesis.KinesisWriterStatisticsMXBean;
import com.kdgregory.logging.common.util.DefaultThreadFactory;
import com.kdgregory.logging.common.util.InternalLogger;
import com.kdgregory.logging.common.util.ThreadFactory;
import java.util.Date;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.core.util.Builder;

@Plugin(name="KinesisAppender", category="Core", elementType="appender")
public class KinesisAppender
extends AbstractAppender<KinesisWriterConfig, KinesisAppenderConfig, KinesisWriterStatistics, KinesisWriterStatisticsMXBean> {
    protected Integer retentionPeriod;

    @PluginBuilderFactory
    public static KinesisAppenderBuilder newBuilder() {
        return new KinesisAppenderBuilder();
    }

    protected KinesisAppender(String name, KinesisAppenderConfig config, InternalLogger internalLogger) {
        super(name, (ThreadFactory)new DefaultThreadFactory("log4j2-kinesis"), new KinesisWriterFactory(), new KinesisWriterStatistics(), KinesisWriterStatisticsMXBean.class, config, internalLogger);
    }

    @Override
    protected KinesisWriterConfig generateWriterConfig() {
        StrSubstitutor l4jsubs = ((KinesisAppenderConfig)this.appenderConfig).getConfiguration().getStrSubstitutor();
        Substitutions subs = new Substitutions(new Date(), 0);
        String actualStreamName = subs.perform(l4jsubs.replace(((KinesisAppenderConfig)this.appenderConfig).getStreamName()));
        String actualPartitionKey = subs.perform(l4jsubs.replace(((KinesisAppenderConfig)this.appenderConfig).getPartitionKey()));
        return new KinesisWriterConfig().setStreamName(actualStreamName).setPartitionKey(actualPartitionKey).setAutoCreate(((KinesisAppenderConfig)this.appenderConfig).getAutoCreate()).setShardCount(((KinesisAppenderConfig)this.appenderConfig).getShardCount()).setRetentionPeriod(((KinesisAppenderConfig)this.appenderConfig).getRetentionPeriod());
    }

    public static class KinesisAppenderBuilder
    extends AbstractAppenderBuilder<KinesisAppenderBuilder>
    implements KinesisAppenderConfig,
    Builder<KinesisAppender> {
        @PluginBuilderAttribute(value="name")
        @Required(message="KinesisAppender: no name provided")
        private String name;
        @PluginBuilderAttribute(value="streamName")
        private String streamName;
        @PluginBuilderAttribute(value="partitionKey")
        private String partitionKey = "{startupTimestamp}";
        @PluginBuilderAttribute(value="autoCreate")
        private boolean autoCreate;
        @PluginBuilderAttribute(value="shardCount")
        private int shardCount = 1;
        @PluginBuilderAttribute(value="retentionPeriod")
        private Integer retentionPeriod;

        @Override
        public String getName() {
            return this.name;
        }

        public KinesisAppenderBuilder setName(String value) {
            this.name = value;
            return this;
        }

        public KinesisAppenderBuilder setStreamName(String value) {
            this.streamName = value;
            return this;
        }

        @Override
        public String getStreamName() {
            return this.streamName;
        }

        public KinesisAppenderBuilder setPartitionKey(String value) {
            this.partitionKey = value;
            return this;
        }

        @Override
        public String getPartitionKey() {
            return this.partitionKey;
        }

        public KinesisAppenderBuilder setAutoCreate(boolean value) {
            this.autoCreate = value;
            return this;
        }

        @Override
        public boolean getAutoCreate() {
            return this.autoCreate;
        }

        public KinesisAppenderBuilder setShardCount(int value) {
            this.shardCount = value;
            return this;
        }

        @Override
        public int getShardCount() {
            return this.shardCount;
        }

        public KinesisAppenderBuilder setRetentionPeriod(Integer value) {
            this.retentionPeriod = value;
            return this;
        }

        @Override
        public Integer getRetentionPeriod() {
            return this.retentionPeriod != null ? this.retentionPeriod : 24;
        }

        public KinesisAppender build() {
            return new KinesisAppender(this.name, this, null);
        }
    }
}

