/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.log4j2.aws.internal;

import com.kdgregory.log4j2.aws.internal.AbstractAppenderConfig;
import com.kdgregory.log4j2.aws.internal.JMXManager;
import com.kdgregory.log4j2.aws.internal.Log4J2InternalLogger;
import com.kdgregory.logging.aws.internal.AbstractWriterConfig;
import com.kdgregory.logging.aws.internal.AbstractWriterStatistics;
import com.kdgregory.logging.common.LogMessage;
import com.kdgregory.logging.common.LogWriter;
import com.kdgregory.logging.common.util.InternalLogger;
import com.kdgregory.logging.common.util.MessageQueue;
import com.kdgregory.logging.common.util.ThreadFactory;
import com.kdgregory.logging.common.util.WriterFactory;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.StringLayout;

public abstract class AbstractAppender<WriterConfigType extends AbstractWriterConfig<WriterConfigType>, AppenderConfigType extends AbstractAppenderConfig, AppenderStatsType extends AbstractWriterStatistics, AppenderStatsMXBeanType>
extends org.apache.logging.log4j.core.appender.AbstractAppender {
    protected ThreadFactory threadFactory;
    protected WriterFactory<WriterConfigType, AppenderStatsType> writerFactory;
    protected InternalLogger internalLogger;
    protected AppenderStatsType appenderStats;
    private Class<AppenderStatsMXBeanType> appenderStatsMXBeanClass;
    private Object initializationLock = new Object();
    protected AppenderConfigType appenderConfig;
    protected Charset layoutCharset = StandardCharsets.UTF_8;
    protected MessageQueue.DiscardAction discardAction;
    protected volatile LogWriter writer;

    protected AbstractAppender(String name, ThreadFactory threadFactory, WriterFactory<WriterConfigType, AppenderStatsType> writerFactory, AppenderStatsType appenderStats, Class<AppenderStatsMXBeanType> appenderStatsMXBeanClass, AppenderConfigType config, InternalLogger providedInternalLogger) {
        super(name, config.getFilter(), config.getLayout());
        Layout<String> layout;
        this.appenderConfig = config;
        this.threadFactory = threadFactory;
        this.writerFactory = writerFactory;
        this.appenderStats = appenderStats;
        this.appenderStatsMXBeanClass = appenderStatsMXBeanClass;
        this.internalLogger = providedInternalLogger != null ? providedInternalLogger : new Log4J2InternalLogger(this);
        this.discardAction = MessageQueue.DiscardAction.lookup((String)config.getDiscardAction());
        if (this.discardAction == null) {
            this.internalLogger.error("invalid discard action: " + config.getDiscardAction(), null);
            this.discardAction = MessageQueue.DiscardAction.oldest;
        }
        if ((layout = config.getLayout()) instanceof StringLayout) {
            this.layoutCharset = ((StringLayout)layout).getCharset();
        }
    }

    public AppenderStatsType getAppenderStatistics() {
        return this.appenderStats;
    }

    public AppenderConfigType getConfig() {
        return this.appenderConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.initializationLock;
        synchronized (object) {
            if (this.isStarted()) {
                return;
            }
            this.startWriter();
            this.registerStatisticsBean();
        }
        super.start();
    }

    public void stop() {
        throw new IllegalStateException("stop() called -- should never happen with Log4J > 2.8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop(long timeout, TimeUnit timeUnit) {
        Object object = this.initializationLock;
        synchronized (object) {
            if (this.writer != null) {
                this.stopWriter(timeout, timeUnit);
            }
            this.unregisterStatisticsBean();
        }
        return super.stop(timeout, timeUnit);
    }

    public void append(LogEvent event) {
        if (!this.isStarted()) {
            this.internalLogger.warn("append called before appender was started");
            return;
        }
        String message = null;
        try {
            message = (String)((Object)this.getConfig().getLayout().toSerializable(event));
        }
        catch (Exception ex) {
            this.internalLogger.error("unable to apply layout", (Throwable)ex);
            return;
        }
        try {
            this.internalAppend(new LogMessage(event.getTimeMillis(), message));
        }
        catch (Exception ex) {
            this.internalLogger.error("unable to append event", (Throwable)ex);
        }
    }

    protected abstract WriterConfigType generateWriterConfig();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWriter() {
        AbstractWriterConfig writerConfig = this.generateWriterConfig().setTruncateOversizeMessages(this.appenderConfig.getTruncateOversizeMessages()).setSynchronousMode(this.appenderConfig.isSynchronous()).setBatchDelay(this.appenderConfig.getBatchDelay()).setDiscardThreshold(this.appenderConfig.getDiscardThreshold()).setDiscardAction(this.discardAction).setClientFactoryMethod(this.appenderConfig.getClientFactory()).setAssumedRole(this.appenderConfig.getAssumedRole()).setClientRegion(this.appenderConfig.getClientRegion()).setClientEndpoint(this.appenderConfig.getClientEndpoint()).setInitializationTimeout(this.appenderConfig.getInitializationTimeout());
        Object object = this.initializationLock;
        synchronized (object) {
            try {
                String header;
                this.writer = this.writerFactory.newLogWriter((Object)writerConfig, this.appenderStats, this.internalLogger);
                this.threadFactory.startWriterThread(this.writer, new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread t, Throwable ex) {
                        AbstractAppender.this.internalLogger.error("unhandled exception in writer", ex);
                        AbstractAppender.this.appenderStats.setLastError(null, ex);
                        AbstractAppender.this.writer = null;
                    }
                });
                if (this.getLayout().getHeader() != null && (header = new String(this.getLayout().getHeader(), this.layoutCharset)).length() > 0) {
                    this.internalAppend(new LogMessage(System.currentTimeMillis(), header));
                }
            }
            catch (Exception ex) {
                this.internalLogger.error("exception while initializing writer", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopWriter(long timeout, TimeUnit timeUnit) {
        Object object = this.initializationLock;
        synchronized (object) {
            try {
                String header;
                if (this.writer == null) {
                    return;
                }
                if (this.getLayout().getFooter() != null && (header = new String(this.getLayout().getFooter(), this.layoutCharset)).length() > 0) {
                    this.internalAppend(new LogMessage(System.currentTimeMillis(), header));
                }
                this.writer.stop();
                if (timeUnit != null) {
                    this.writer.waitUntilStopped(timeUnit.toMillis(timeout));
                }
            }
            catch (Exception ex) {
                this.internalLogger.error("exception while shutting down writer", (Throwable)ex);
            }
            this.writer = null;
        }
    }

    protected void registerStatisticsBean() {
        JMXManager.getInstance().addStatsBean(this.getName(), (AbstractWriterStatistics)this.appenderStats, this.appenderStatsMXBeanClass);
    }

    protected void unregisterStatisticsBean() {
        JMXManager.getInstance().removeStatsBean(this.getName());
    }

    private void internalAppend(LogMessage message) {
        if (message == null) {
            this.internalLogger.error("internal error: message was null", null);
            return;
        }
        this.writer.addMessage(message);
    }
}

