/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logback.aws;

import ch.qos.logback.access.spi.IAccessEvent;
import com.kdgregory.logback.aws.internal.AbstractJsonLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class JsonAccessLayout
extends AbstractJsonLayout<IAccessEvent> {
    private boolean enableServer;
    private boolean enableRemoteHost;
    private boolean enableRemoteUser;
    private boolean enableSessionId;
    private boolean enableRequestHeaders;
    private boolean enableResponseHeaders;
    private boolean enableCookies;
    private boolean enableParameters;
    private boolean enableQueryString;
    private String includeHeaders;
    private String excludeHeaders;
    private boolean whitelistAllHeaders = false;
    private Set<String> headerWhitelist = Collections.emptySet();
    private Set<String> headerBlacklist = Collections.emptySet();
    private String includeCookies;
    private String excludeCookies;
    private boolean whitelistAllCookies = false;
    private Set<String> cookieWhitelist = Collections.emptySet();
    private Set<String> cookieBlacklist = Collections.emptySet();
    private String includeParameters;
    private String excludeParameters;
    private boolean whitelistAllParameters = false;
    private Set<String> parameterWhitelist = Collections.emptySet();
    private Set<String> parameterBlacklist = Collections.emptySet();

    public void setEnableServer(boolean value) {
        this.enableServer = value;
    }

    public boolean getEnableServer() {
        return this.enableServer;
    }

    public void setEnableRemoteHost(boolean value) {
        this.enableRemoteHost = value;
    }

    public boolean getEnableRemoteHost() {
        return this.enableRemoteHost;
    }

    public void setEnableRemoteUser(boolean value) {
        this.enableRemoteUser = value;
    }

    public boolean getEnableRemoteUser() {
        return this.enableRemoteUser;
    }

    public void setEnableSessionId(boolean value) {
        this.enableSessionId = value;
    }

    public boolean getEnableSessionId() {
        return this.enableSessionId;
    }

    public void setEnableRequestHeaders(boolean value) {
        this.enableRequestHeaders = value;
    }

    public boolean getEnableRequestHeaders() {
        return this.enableRequestHeaders;
    }

    public void setEnableResponseHeaders(boolean value) {
        this.enableResponseHeaders = value;
    }

    public boolean getEnableResponseHeaders() {
        return this.enableResponseHeaders;
    }

    public void setIncludeHeaders(String value) {
        this.includeHeaders = value;
        if ("*".equals(value)) {
            this.whitelistAllHeaders = true;
        } else {
            this.headerWhitelist = new HashSet<String>();
            for (String headerName : value.split(",")) {
                this.headerWhitelist.add(headerName.toLowerCase());
            }
        }
    }

    public String getIncludeHeaders() {
        return this.includeHeaders;
    }

    public void setExcludeHeaders(String value) {
        this.excludeHeaders = value;
        this.headerBlacklist = new HashSet<String>();
        for (String headerName : value.split(",")) {
            this.headerBlacklist.add(headerName.toLowerCase());
        }
    }

    public String getExcludeHeaders() {
        return this.excludeHeaders;
    }

    public void setEnableParameters(boolean value) {
        this.enableParameters = value;
    }

    public boolean getEnableParameters() {
        return this.enableParameters;
    }

    public void setIncludeParameters(String value) {
        this.includeParameters = value;
        if ("*".equals(value)) {
            this.whitelistAllParameters = true;
        } else {
            this.parameterWhitelist = new HashSet<String>();
            for (String paramName : value.split(",")) {
                this.parameterWhitelist.add(paramName.toLowerCase());
            }
        }
    }

    public String getIncludeParameters() {
        return this.includeParameters;
    }

    public void setExcludeParameters(String value) {
        this.excludeParameters = value;
        this.parameterBlacklist = new HashSet<String>(Arrays.asList(value.split(",")));
    }

    public String getExcludeParameters() {
        return this.excludeParameters;
    }

    public void setEnableCookies(boolean value) {
        this.enableCookies = value;
    }

    public boolean getEnableCookies() {
        return this.enableCookies;
    }

    public void setIncludeCookies(String value) {
        this.includeCookies = value;
        if ("*".equals(value)) {
            this.whitelistAllCookies = true;
        } else {
            this.cookieWhitelist = new HashSet<String>();
            for (String cookieName : value.split(",")) {
                this.cookieWhitelist.add(cookieName.toLowerCase());
            }
        }
    }

    public String getIncludeCookies() {
        return this.includeCookies;
    }

    public void setExcludeCookies(String value) {
        this.excludeCookies = value;
        this.cookieBlacklist = new HashSet<String>(Arrays.asList(value.split(",")));
    }

    public String getExcludeCookies() {
        return this.excludeCookies;
    }

    public void setEnableQueryString(boolean value) {
        this.enableQueryString = value;
    }

    public boolean getEnableQueryString() {
        return this.enableQueryString;
    }

    public String doLayout(IAccessEvent event) {
        String forwardedFor;
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        map.put("timestamp", new Date(event.getTimeStamp()));
        map.put("thread", event.getThreadName());
        map.put("elapsedTime", event.getElapsedTime());
        map.put("protocol", event.getProtocol());
        map.put("requestMethod", event.getMethod());
        map.put("requestURI", event.getRequestURI());
        map.put("statusCode", event.getStatusCode());
        map.put("bytesSent", event.getContentLength());
        map.put("remoteIP", event.getRemoteAddr());
        if (this.enableQueryString) {
            map.put("queryString", event.getQueryString());
        }
        if (this.enableRemoteHost) {
            map.put("remoteHost", event.getRemoteHost());
        }
        if (this.enableServer) {
            map.put("server", event.getServerName());
        }
        if (this.enableRemoteUser) {
            map.put("user", event.getRemoteUser());
        }
        if (this.enableSessionId) {
            try {
                map.put("sessionId", event.getSessionID());
            }
            catch (Exception ex) {
                map.put("sessionId", "");
            }
        }
        if (this.enableRequestHeaders) {
            map.put("requestHeaders", JsonAccessLayout.applyFilters(event.getRequestHeaderMap(), this.whitelistAllHeaders, this.headerWhitelist, this.headerBlacklist));
        }
        if (this.enableResponseHeaders) {
            map.put("responseHeaders", JsonAccessLayout.applyFilters(event.getResponseHeaderMap(), this.whitelistAllHeaders, this.headerWhitelist, this.headerBlacklist));
        }
        if (this.enableCookies) {
            map.put("cookies", this.getCookies(event.getRequest()));
        }
        if (this.enableParameters) {
            map.put("parameters", JsonAccessLayout.applyFilters(event.getRequestParameterMap(), this.whitelistAllParameters, this.parameterWhitelist, this.parameterBlacklist));
        }
        if ((forwardedFor = event.getRequestHeader("x-forwarded-for")) != null) {
            map.put("forwardedFor", forwardedFor);
        }
        return this.addCommonAttributesAndConvert(map);
    }

    private List<Map<String, Object>> getCookies(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Cookie cookie : cookies) {
            if (!JsonAccessLayout.include(cookie.getName(), this.whitelistAllCookies, this.cookieWhitelist, this.cookieBlacklist)) continue;
            TreeMap<String, Object> entry = new TreeMap<String, Object>();
            entry.put("name", cookie.getName());
            entry.put("domain", cookie.getDomain());
            entry.put("path", cookie.getPath());
            entry.put("value", cookie.getValue());
            entry.put("maxAge", cookie.getMaxAge());
            entry.put("comment", cookie.getComment());
            entry.put("version", cookie.getVersion());
            entry.put("isSecure", cookie.getSecure());
            entry.put("isHttpOnly", cookie.isHttpOnly());
            result.add(entry);
        }
        return result;
    }

    private static Map<String, Object> applyFilters(Map<String, ?> source, boolean whitelistAll, Set<String> whitelist, Set<String> blacklist) {
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        for (Map.Entry<String, ?> entry : source.entrySet()) {
            String key = entry.getKey();
            if (!JsonAccessLayout.include(key, whitelistAll, whitelist, blacklist)) continue;
            result.put(key, JsonAccessLayout.flatten(entry.getValue()));
        }
        return result;
    }

    private static boolean include(String name, boolean whitelistAll, Set<String> whitelist, Set<String> blacklist) {
        name = name.toLowerCase();
        boolean whitelisted = whitelistAll || whitelist.contains(name);
        boolean blacklisted = blacklist.contains(name);
        return whitelisted && !blacklisted;
    }

    private static Object flatten(Object value) {
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            value = array.length == 1 ? array[0] : Arrays.asList(array);
        }
        return String.valueOf(value);
    }
}

