/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logback.aws;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import com.kdgregory.logback.aws.internal.AbstractJsonLayout;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;

public class JsonLayout
extends AbstractJsonLayout<ILoggingEvent> {
    private boolean enableLocation;

    public void setEnableLocation(boolean value) {
        this.enableLocation = value;
    }

    public boolean getEnableLocation() {
        return this.enableLocation;
    }

    public String doLayout(ILoggingEvent event) {
        StackTraceElement[] callerData;
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        map.put("timestamp", new Date(event.getTimeStamp()));
        map.put("thread", event.getThreadName());
        map.put("logger", event.getLoggerName());
        map.put("level", event.getLevel().toString());
        map.put("message", event.getFormattedMessage());
        List<String> exceptionInfo = JsonLayout.extractExceptionInfo(event);
        if (exceptionInfo != null) {
            map.put("exception", exceptionInfo);
        }
        if (event.getMDCPropertyMap() != null && !event.getMDCPropertyMap().isEmpty()) {
            map.put("mdc", event.getMDCPropertyMap());
        }
        if (this.enableLocation && (callerData = event.getCallerData()) != null && event.getCallerData().length > 0) {
            StackTraceElement info = callerData[0];
            TreeMap<String, Object> location = new TreeMap<String, Object>();
            location.put("className", info.getClassName());
            location.put("methodName", info.getMethodName());
            location.put("fileName", info.getFileName());
            location.put("lineNumber", info.getLineNumber());
            map.put("locationInfo", location);
        }
        return this.addCommonAttributesAndConvert(map);
    }

    private static List<String> extractExceptionInfo(ILoggingEvent event) {
        return event.getThrowableProxy() == null ? null : JsonLayout.appendThrowable(new ArrayList<String>(), event.getThrowableProxy());
    }

    private static List<String> appendThrowable(List<String> entries, IThrowableProxy throwable) {
        String optCausedBy = entries.isEmpty() ? "" : "Caused by: ";
        String initialLine = optCausedBy + throwable.getClassName() + ": " + throwable.getMessage();
        entries.add(initialLine);
        for (StackTraceElementProxy ste : throwable.getStackTraceElementProxyArray()) {
            entries.add(ste.getSTEAsString());
        }
        return throwable.getCause() == null ? entries : JsonLayout.appendThrowable(entries, throwable.getCause());
    }
}

