/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logback.aws;

import com.kdgregory.logback.aws.internal.AbstractAppender;
import com.kdgregory.logging.aws.common.Substitutions;
import com.kdgregory.logging.aws.kinesis.KinesisWriterConfig;
import com.kdgregory.logging.aws.kinesis.KinesisWriterFactory;
import com.kdgregory.logging.aws.kinesis.KinesisWriterStatistics;
import com.kdgregory.logging.aws.kinesis.KinesisWriterStatisticsMXBean;
import com.kdgregory.logging.common.util.DefaultThreadFactory;
import com.kdgregory.logging.common.util.ThreadFactory;
import java.util.Date;

public class KinesisAppender<LogbackEventType>
extends AbstractAppender<KinesisWriterConfig, KinesisWriterStatistics, KinesisWriterStatisticsMXBean, LogbackEventType> {
    private String actualStreamName;
    private String actualPartitionKey;

    public KinesisAppender() {
        super(new KinesisWriterConfig(), (ThreadFactory)new DefaultThreadFactory("logback-kinesis"), new KinesisWriterFactory(), new KinesisWriterStatistics(), KinesisWriterStatisticsMXBean.class);
    }

    public void setStreamName(String value) {
        if (this.actualStreamName != null) {
            throw new IllegalArgumentException("appender cannot be reconfigured after processing messages");
        }
        ((KinesisWriterConfig)this.appenderConfig).setStreamName(value);
    }

    public String getStreamName() {
        return ((KinesisWriterConfig)this.appenderConfig).getStreamName();
    }

    public void setPartitionKey(String value) {
        if (this.actualStreamName != null) {
            throw new IllegalArgumentException("appender cannot be reconfigured after processing messages");
        }
        ((KinesisWriterConfig)this.appenderConfig).setPartitionKey(value);
    }

    public String getPartitionKey() {
        return ((KinesisWriterConfig)this.appenderConfig).getPartitionKey();
    }

    public void setAutoCreate(boolean value) {
        ((KinesisWriterConfig)this.appenderConfig).setAutoCreate(value);
    }

    public boolean isAutoCreate() {
        return ((KinesisWriterConfig)this.appenderConfig).getAutoCreate();
    }

    public void setShardCount(int value) {
        ((KinesisWriterConfig)this.appenderConfig).setShardCount(value);
    }

    public int getShardCount() {
        return ((KinesisWriterConfig)this.appenderConfig).getShardCount();
    }

    public void setRetentionPeriod(int value) {
        if (value <= 24 || value > 168) {
            throw new IllegalArgumentException("retentionPeriod must be between 25 and 168");
        }
        ((KinesisWriterConfig)this.appenderConfig).setRetentionPeriod(Integer.valueOf(value));
    }

    public int getRetentionPeriod() {
        return ((KinesisWriterConfig)this.appenderConfig).getRetentionPeriod() != null ? ((KinesisWriterConfig)this.appenderConfig).getRetentionPeriod() : 24;
    }

    @Override
    protected KinesisWriterConfig generateWriterConfig() {
        Substitutions subs = new Substitutions(new Date(), 0);
        this.actualStreamName = subs.perform(((KinesisWriterConfig)this.appenderConfig).getStreamName());
        this.actualPartitionKey = subs.perform(((KinesisWriterConfig)this.appenderConfig).getPartitionKey());
        return ((KinesisWriterConfig)((KinesisWriterConfig)this.appenderConfig).clone()).setStreamName(this.actualStreamName).setPartitionKey(this.actualPartitionKey);
    }
}

