/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logback.aws.internal;

import ch.qos.logback.core.LayoutBase;
import com.kdgregory.logging.aws.common.Substitutions;
import com.kdgregory.logging.common.internal.JsonConverter;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;

public abstract class AbstractJsonLayout<E>
extends LayoutBase<E> {
    private String processId;
    private String hostname;
    private String instanceId;
    private String accountId;
    private Map<String, String> tags;
    private ThreadLocal<JsonConverter> converterTL = new ThreadLocal<JsonConverter>(){

        @Override
        protected JsonConverter initialValue() {
            return new JsonConverter();
        }
    };
    private boolean enableHostname = true;
    private boolean appendNewlines;
    private boolean enableInstanceId;
    private boolean enableAccountId;
    private String rawTags;

    public void setAppendNewlines(boolean value) {
        this.appendNewlines = value;
    }

    public boolean getAppendNewlines() {
        return this.appendNewlines;
    }

    public void setEnableInstanceId(boolean value) {
        this.enableInstanceId = value;
    }

    public boolean getEnableInstanceId() {
        return this.enableInstanceId;
    }

    public boolean getEnableAccountId() {
        return this.enableAccountId;
    }

    public void setEnableAccountId(boolean enableAccountId) {
        this.enableAccountId = enableAccountId;
    }

    public void setEnableHostname(boolean value) {
        this.enableHostname = value;
    }

    public boolean getEnableHostname() {
        return this.enableHostname;
    }

    public void setTags(String value) {
        this.rawTags = value;
    }

    public String getTags() {
        return this.rawTags;
    }

    public void start() {
        Substitutions subs = new Substitutions(new Date(), 0);
        this.processId = subs.perform("{pid}");
        if ("unknown".equals(this.processId)) {
            this.processId = null;
        }
        if (this.enableHostname) {
            this.hostname = subs.perform("{hostname}");
            if ("unknown".equals(this.hostname)) {
                this.hostname = null;
            }
        }
        if (this.enableInstanceId) {
            this.instanceId = subs.perform("{instanceId}");
            if ("{instanceId}".equals(this.instanceId)) {
                this.instanceId = null;
            }
        }
        if (this.enableAccountId) {
            this.accountId = subs.perform("{aws:accountId}");
            if ("unknown-account".equals(this.accountId)) {
                this.accountId = null;
            }
        }
        if (this.rawTags != null && !this.rawTags.isEmpty()) {
            this.tags = new TreeMap<String, String>();
            for (String tagdef : this.rawTags.split(",")) {
                String[] splitdef = tagdef.split("=");
                if (splitdef.length != 2) {
                    throw new IllegalArgumentException("invalid tag definition: " + tagdef);
                }
                this.tags.put(splitdef[0], subs.perform(splitdef[1]));
            }
        }
        super.start();
    }

    public void stop() {
        this.converterTL.remove();
        super.stop();
    }

    protected String addCommonAttributesAndConvert(Map<String, Object> map) {
        if (this.processId != null) {
            map.put("processId", this.processId);
        }
        if (this.hostname != null) {
            map.put("hostname", this.hostname);
        }
        if (this.instanceId != null) {
            map.put("instanceId", this.instanceId);
        }
        if (this.accountId != null) {
            map.put("accountId", this.accountId);
        }
        if (this.tags != null) {
            map.put("tags", this.tags);
        }
        String json = this.converterTL.get().convert(map);
        if (this.getAppendNewlines()) {
            json = json + "\n";
        }
        return json;
    }
}

