/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logback.aws.internal;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.ContextAwareImpl;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.WarnStatus;
import com.kdgregory.logging.common.util.InternalLogger;
import java.util.concurrent.ConcurrentLinkedQueue;

public class LateInitializedLogbackInternalLogger
implements InternalLogger {
    private volatile ContextAware destination;
    private String origin;
    private ConcurrentLinkedQueue<Status> deferredMessages = new ConcurrentLinkedQueue();

    public LateInitializedLogbackInternalLogger(String origin) {
        this.origin = origin;
    }

    public synchronized void setDestination(Context context) {
        if (this.destination != null) {
            return;
        }
        this.destination = new ContextAwareImpl(context, (Object)this.origin);
        for (Status message : this.deferredMessages) {
            this.destination.addStatus(message);
        }
    }

    public void debug(String message) {
        InfoStatus status = new InfoStatus(message, (Object)this.origin);
        if (this.destination == null) {
            this.deferredMessages.add((Status)status);
        } else {
            this.destination.addStatus((Status)status);
        }
    }

    public void warn(String message) {
        WarnStatus status = new WarnStatus(message, (Object)this.origin);
        if (this.destination == null) {
            this.deferredMessages.add((Status)status);
        } else {
            this.destination.addStatus((Status)status);
        }
    }

    public void error(String message, Throwable ex) {
        ErrorStatus status;
        ErrorStatus errorStatus = status = ex != null ? new ErrorStatus(message, (Object)this.origin, ex) : new ErrorStatus(message, (Object)this.origin);
        if (this.destination == null) {
            this.deferredMessages.add((Status)status);
        } else {
            this.destination.addStatus((Status)status);
        }
    }
}

