/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.aws.cloudwatch;

import com.kdgregory.logging.aws.cloudwatch.CloudWatchConstants;
import com.kdgregory.logging.aws.internal.AbstractWriterConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class CloudWatchWriterConfig
extends AbstractWriterConfig<CloudWatchWriterConfig> {
    private String logGroupName;
    private String logStreamName;
    private Integer retentionPeriod;
    private boolean dedicatedWriter;

    public String getLogGroupName() {
        return this.logGroupName;
    }

    public CloudWatchWriterConfig setLogGroupName(String value) {
        this.logGroupName = value;
        return this;
    }

    public String getLogStreamName() {
        return this.logStreamName;
    }

    public CloudWatchWriterConfig setLogStreamName(String value) {
        this.logStreamName = value;
        return this;
    }

    public Integer getRetentionPeriod() {
        return this.retentionPeriod;
    }

    public CloudWatchWriterConfig setRetentionPeriod(Integer value) {
        this.retentionPeriod = value;
        return this;
    }

    public boolean getDedicatedWriter() {
        return this.dedicatedWriter;
    }

    public CloudWatchWriterConfig setDedicatedWriter(boolean value) {
        this.dedicatedWriter = value;
        return this;
    }

    public List<String> validate() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.logGroupName == null) {
            result.add("missing log group name");
        } else if (this.logGroupName.isEmpty()) {
            result.add("blank log group name");
        } else if (!Pattern.matches("[A-Za-z0-9_/.-]{1,512}", this.logGroupName)) {
            result.add("invalid log group name: " + this.logGroupName);
        }
        if (this.logStreamName == null) {
            result.add("missing log stream name");
        } else if (this.logStreamName.isEmpty()) {
            result.add("blank log stream name");
        } else if (!Pattern.matches("[^:*]{1,512}", this.logStreamName)) {
            result.add("invalid log stream name: " + this.logStreamName);
        }
        try {
            CloudWatchConstants.validateRetentionPeriod(this.retentionPeriod);
        }
        catch (IllegalArgumentException ex) {
            result.add(ex.getMessage());
        }
        return result;
    }
}

