/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.aws.kinesis;

import com.kdgregory.logging.aws.internal.AbstractWriterConfig;
import com.kdgregory.logging.aws.kinesis.PartitionKeyHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class KinesisWriterConfig
extends AbstractWriterConfig<KinesisWriterConfig> {
    private String streamName;
    private String partitionKey;
    private boolean autoCreate;
    private int shardCount;
    private Integer retentionPeriod;
    private PartitionKeyHelper partitionKeyHelper;

    public String getStreamName() {
        return this.streamName;
    }

    public KinesisWriterConfig setStreamName(String value) {
        this.streamName = value;
        return this;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }

    public KinesisWriterConfig setPartitionKey(String value) {
        this.partitionKey = value;
        this.partitionKeyHelper = new PartitionKeyHelper(value);
        return this;
    }

    public boolean getAutoCreate() {
        return this.autoCreate;
    }

    public KinesisWriterConfig setAutoCreate(boolean value) {
        this.autoCreate = value;
        return this;
    }

    public int getShardCount() {
        return this.shardCount;
    }

    public KinesisWriterConfig setShardCount(int value) {
        this.shardCount = value;
        return this;
    }

    public Integer getRetentionPeriod() {
        return this.retentionPeriod;
    }

    public KinesisWriterConfig setRetentionPeriod(Integer value) {
        this.retentionPeriod = value;
        return this;
    }

    public List<String> validate() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.streamName == null) {
            result.add("missing stream name");
        } else if (this.streamName.isEmpty()) {
            result.add("blank stream name");
        } else if (this.streamName.length() > 128) {
            result.add("stream name too long");
        } else if (!Pattern.matches("[a-zA-Z0-9_.-]{1,128}", this.streamName)) {
            result.add("invalid stream name: " + this.streamName);
        }
        if (this.partitionKey == null) {
            result.add("missing partition key");
        } else if (this.partitionKey.length() > 256) {
            result.add("partition key too long");
        }
        if (this.autoCreate && this.retentionPeriod != null) {
            if (this.retentionPeriod < 24) {
                result.add("minimum retention period is 24 hours");
            } else if (this.retentionPeriod > 8760) {
                result.add("maximum retention period is 8760 hours");
            }
        }
        return result;
    }

    public PartitionKeyHelper getPartitionKeyHelper() {
        return this.partitionKeyHelper;
    }
}

