/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.aws.sns;

import com.kdgregory.logging.aws.facade.SNSFacade;
import com.kdgregory.logging.aws.internal.AbstractLogWriter;
import com.kdgregory.logging.aws.sns.SNSWriterConfig;
import com.kdgregory.logging.aws.sns.SNSWriterStatistics;
import com.kdgregory.logging.common.LogMessage;
import com.kdgregory.logging.common.util.InternalLogger;
import java.util.ArrayList;
import java.util.List;

public class SNSLogWriter
extends AbstractLogWriter<SNSWriterConfig, SNSWriterStatistics> {
    private SNSFacade facade;

    public SNSLogWriter(SNSWriterConfig config, SNSWriterStatistics stats, InternalLogger logger, SNSFacade facade) {
        super(config, stats, logger);
        this.facade = facade;
        stats.setActualTopicName(config.getTopicName());
        stats.setActualTopicArn(config.getTopicArn());
        stats.setActualSubject(config.getSubject());
    }

    @Override
    public int maxMessageSize() {
        return 262144;
    }

    @Override
    protected boolean ensureDestinationAvailable() {
        List<String> configErrors = ((SNSWriterConfig)this.config).validate();
        if (!configErrors.isEmpty()) {
            for (String error : configErrors) {
                this.reportError("configuration error: " + error, null);
            }
            return false;
        }
        try {
            String topicArn = this.facade.lookupTopic();
            if (topicArn == null && (topicArn = this.optCreateTopic()) == null) {
                return false;
            }
            ((SNSWriterConfig)this.config).setTopicArn(topicArn);
            ((SNSWriterStatistics)this.stats).setActualTopicArn(topicArn);
            ((SNSWriterStatistics)this.stats).setActualTopicName(topicArn.replaceAll(".*:", ""));
            return true;
        }
        catch (Exception ex) {
            this.reportError("unable to configure", ex);
            return false;
        }
    }

    @Override
    protected List<LogMessage> sendBatch(List<LogMessage> currentBatch) {
        ArrayList<LogMessage> failures = new ArrayList<LogMessage>();
        for (LogMessage message : currentBatch) {
            try {
                this.facade.publish(message);
            }
            catch (Exception ex) {
                ((SNSWriterStatistics)this.stats).setLastError("failed to publish: " + ex.getMessage(), ex);
                failures.add(message);
            }
        }
        return failures;
    }

    @Override
    protected int effectiveSize(LogMessage message) {
        return message.size();
    }

    @Override
    protected boolean withinServiceLimits(int batchBytes, int numMessages) {
        return batchBytes <= 262144 && numMessages <= 1;
    }

    @Override
    protected void stopAWSClient() {
        this.facade.shutdown();
    }

    private String optCreateTopic() {
        if (((SNSWriterConfig)this.config).getTopicArn() != null) {
            this.reportError("topic does not exist: " + ((SNSWriterConfig)this.config).getTopicArn(), null);
            return null;
        }
        if (!((SNSWriterConfig)this.config).getAutoCreate()) {
            this.reportError("topic does not exist and auto-create not enabled: " + ((SNSWriterConfig)this.config).getTopicName(), null);
            return null;
        }
        this.logger.debug("creating SNS topic: " + ((SNSWriterConfig)this.config).getTopicName());
        return this.facade.createTopic();
    }
}

