/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.aws.cloudwatch;

import com.kdgregory.logging.aws.cloudwatch.CloudWatchWriterConfig;
import com.kdgregory.logging.aws.cloudwatch.CloudWatchWriterStatistics;
import com.kdgregory.logging.aws.facade.CloudWatchFacade;
import com.kdgregory.logging.aws.facade.CloudWatchFacadeException;
import com.kdgregory.logging.aws.internal.AbstractLogWriter;
import com.kdgregory.logging.common.LogMessage;
import com.kdgregory.logging.common.util.InternalLogger;
import com.kdgregory.logging.common.util.RetryManager;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public class CloudWatchLogWriter
extends AbstractLogWriter<CloudWatchWriterConfig, CloudWatchWriterStatistics> {
    private CloudWatchFacade facade;
    protected RetryManager describeRetry = new RetryManager(50L, 5000L, true);
    protected RetryManager createRetry = new RetryManager(200L, 5000L, true);
    protected RetryManager sendRetry = new RetryManager(200L, 2000L, true);
    private String sequenceToken;

    public CloudWatchLogWriter(CloudWatchWriterConfig config, CloudWatchWriterStatistics stats, InternalLogger logger, CloudWatchFacade facade) {
        super(config, stats, logger);
        this.facade = facade;
        ((CloudWatchWriterStatistics)this.stats).setActualLogGroupName(config.getLogGroupName());
        ((CloudWatchWriterStatistics)this.stats).setActualLogStreamName(config.getLogStreamName());
    }

    @Override
    public int maxMessageSize() {
        return 262118;
    }

    @Override
    protected boolean ensureDestinationAvailable() {
        List<String> configErrors = ((CloudWatchWriterConfig)this.config).validate();
        if (!configErrors.isEmpty()) {
            for (String error : configErrors) {
                this.reportError(error, null);
            }
            return false;
        }
        try {
            if (this.facade.findLogGroup() == null) {
                this.createLogGroup();
            } else {
                this.logger.debug("using existing CloudWatch log group: " + ((CloudWatchWriterConfig)this.config).getLogGroupName());
            }
            if (this.facade.retrieveSequenceToken() == null) {
                this.createLogStream();
            } else {
                this.logger.debug("using existing CloudWatch log stream: " + ((CloudWatchWriterConfig)this.config).getLogStreamName());
            }
            return true;
        }
        catch (Throwable ex) {
            this.reportError("unable to configure log group/stream", ex);
            return false;
        }
    }

    @Override
    protected List<LogMessage> sendBatch(List<LogMessage> batch) {
        if (batch.isEmpty()) {
            return batch;
        }
        Collections.sort(batch);
        List result = this.sendRetry.invoke(() -> {
            try {
                this.sequenceToken = this.facade.putEvents(this.nextSequenceToken(), batch);
                return Collections.emptyList();
            }
            catch (CloudWatchFacadeException ex) {
                switch (ex.getReason()) {
                    case THROTTLING: {
                        ((CloudWatchWriterStatistics)this.stats).incrementThrottledWrites();
                        return null;
                    }
                    case INVALID_SEQUENCE_TOKEN: {
                        this.sequenceToken = null;
                        ((CloudWatchWriterStatistics)this.stats).updateWriterRaceRetries();
                        return null;
                    }
                    case ALREADY_PROCESSED: {
                        this.logger.warn("received DataAlreadyAcceptedException, dropping batch");
                        return Collections.emptyList();
                    }
                    case MISSING_LOG_GROUP: 
                    case MISSING_LOG_STREAM: {
                        this.reportError(ex.getMessage(), ex);
                        this.ensureDestinationAvailable();
                        return batch;
                    }
                }
                this.reportError("failed to send: " + ex.getMessage(), ex.getCause());
                return batch;
            }
        });
        if (result != null) {
            return result;
        }
        if (this.sequenceToken == null) {
            this.logger.warn("batch failed: unrecovered sequence token race");
            ((CloudWatchWriterStatistics)this.stats).updateUnrecoveredWriterRaceRetries();
        } else {
            this.logger.warn("batch failed: repeated throttling");
        }
        return batch;
    }

    @Override
    protected int effectiveSize(LogMessage message) {
        return message.size() + 26;
    }

    @Override
    protected boolean withinServiceLimits(int batchBytes, int numMessages) {
        return batchBytes <= 0x100000 && numMessages <= 10000;
    }

    @Override
    protected void stopAWSClient() {
        try {
            this.facade.shutdown();
        }
        catch (CloudWatchFacadeException ex) {
            this.reportError("exception shutting down CloudWatch client", ex);
        }
    }

    private void createLogGroup() {
        this.logger.debug("creating CloudWatch log group: " + ((CloudWatchWriterConfig)this.config).getLogGroupName());
        this.createRetry.invoke(() -> {
            this.facade.createLogGroup();
            return Boolean.TRUE;
        }, new DefaultExceptionHandler());
        String logGroupArn = this.describeRetry.invoke(() -> this.facade.findLogGroup());
        if (logGroupArn == null) {
            throw new RuntimeException("timed out while waiting for CloudWatch log group");
        }
        try {
            if (((CloudWatchWriterConfig)this.config).getRetentionPeriod() != null) {
                this.logger.debug("setting retention period to: " + ((CloudWatchWriterConfig)this.config).getRetentionPeriod());
                this.facade.setLogGroupRetention();
            }
        }
        catch (CloudWatchFacadeException ex) {
            this.logger.error("exception setting retention policy", ex);
        }
    }

    private void createLogStream() {
        this.logger.debug("creating CloudWatch log stream: " + ((CloudWatchWriterConfig)this.config).getLogStreamName());
        this.createRetry.invoke(() -> {
            this.facade.createLogStream();
            return Boolean.TRUE;
        }, new DefaultExceptionHandler());
        this.sequenceToken = null;
        this.nextSequenceToken();
    }

    private String nextSequenceToken() {
        if (!((CloudWatchWriterConfig)this.config).getDedicatedWriter() || this.sequenceToken == null) {
            this.sequenceToken = this.describeRetry.invoke(() -> this.facade.retrieveSequenceToken());
        }
        return this.sequenceToken;
    }

    private static class DefaultExceptionHandler
    implements Consumer<RuntimeException> {
        private DefaultExceptionHandler() {
        }

        @Override
        public void accept(RuntimeException ex) {
            if (ex instanceof CloudWatchFacadeException && ((CloudWatchFacadeException)ex).isRetryable()) {
                return;
            }
            throw ex;
        }
    }
}

