/*
 * Decompiled with CFR 0.152.
 */
package com.kdgregory.logging.aws.common;

import com.kdgregory.logging.aws.facade.FacadeFactory;
import com.kdgregory.logging.aws.facade.InfoFacade;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;

public class Substitutions {
    private InfoFacade infoFacade;
    private SequenceSubstitutor sequenceSubstitutor;
    private DateSubstitutor dateSubstitutor;
    private TimestampSubstitutor timestampSubstitutor;
    private HourlyTimestampSubstitutor hourlyTimestampSubstitutor;
    private StartupTimestampSubstitutor startupTimestampSubstitutor;
    private PidSubstitutor pidSubstitutor;
    private HostnameSubstitutor hostnameSubstitutor;
    private UUIDSubstitutor uuidSubstitutor;
    private SyspropSubstitutor syspropSubstitutor;
    private EnvarSubstitutor envarSubstitutor;
    private AwsAccountIdSubstitutor awsAccountIdSubstitutor;
    private EC2InstanceIdSubstitutor ec2InstanceIdSubstitutor;
    private EC2RegionSubstitutor ec2RegionSubstitutor;
    private EC2TagSubstitutor ec2TagSubstitutor;
    private SSMSubstitutor ssmSubstitutor;

    public Substitutions(Date now, int sequence, InfoFacade infoFacade) {
        this.infoFacade = infoFacade;
        RuntimeMXBean runtimeMx = ManagementFactory.getRuntimeMXBean();
        this.sequenceSubstitutor = new SequenceSubstitutor(sequence);
        this.dateSubstitutor = new DateSubstitutor(now);
        this.timestampSubstitutor = new TimestampSubstitutor(now);
        this.hourlyTimestampSubstitutor = new HourlyTimestampSubstitutor(now);
        this.startupTimestampSubstitutor = new StartupTimestampSubstitutor(runtimeMx);
        this.pidSubstitutor = new PidSubstitutor(runtimeMx);
        this.hostnameSubstitutor = new HostnameSubstitutor(runtimeMx);
        this.uuidSubstitutor = new UUIDSubstitutor();
        this.syspropSubstitutor = new SyspropSubstitutor();
        this.envarSubstitutor = new EnvarSubstitutor();
        this.awsAccountIdSubstitutor = new AwsAccountIdSubstitutor();
        this.ec2InstanceIdSubstitutor = new EC2InstanceIdSubstitutor();
        this.ec2RegionSubstitutor = new EC2RegionSubstitutor();
        this.ec2TagSubstitutor = new EC2TagSubstitutor();
        this.ssmSubstitutor = new SSMSubstitutor();
    }

    public Substitutions(Date now, int sequence) {
        this(now, sequence, null);
    }

    public String perform(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(512);
        for (String token : this.tokenize(input)) {
            if (token.startsWith("{")) {
                sb.append(this.sequenceSubstitutor.perform(this.dateSubstitutor.perform(this.timestampSubstitutor.perform(this.hourlyTimestampSubstitutor.perform(this.startupTimestampSubstitutor.perform(this.pidSubstitutor.perform(this.hostnameSubstitutor.perform(this.uuidSubstitutor.perform(this.syspropSubstitutor.perform(this.envarSubstitutor.perform(this.awsAccountIdSubstitutor.perform(this.ec2InstanceIdSubstitutor.perform(this.ec2RegionSubstitutor.perform(this.ec2TagSubstitutor.perform(this.ssmSubstitutor.perform(token))))))))))))))));
                continue;
            }
            sb.append(token);
        }
        return sb.toString();
    }

    private InfoFacade infoFacade() {
        if (this.infoFacade == null) {
            this.infoFacade = FacadeFactory.createFacade(InfoFacade.class);
        }
        return this.infoFacade;
    }

    private List<String> tokenize(String input) {
        ArrayList<String> result = new ArrayList<String>();
        int ii = 0;
        while (ii < input.length()) {
            int next = input.indexOf(123, ii);
            if (next < 0) {
                result.add(input.substring(ii));
                break;
            }
            result.add(input.substring(ii, next));
            ii = input.indexOf(125, next);
            if (ii < 0) {
                result.add(input.substring(next));
                break;
            }
            result.add(input.substring(next, ++ii));
        }
        return result;
    }

    private class SSMSubstitutor
    extends AbstractSubstitutor {
        public SSMSubstitutor() {
            super("{ssm:");
        }

        @Override
        protected String retrieveValue(String name) {
            if (name == null || name.isEmpty()) {
                return null;
            }
            return Substitutions.this.infoFacade().retrieveParameter(name);
        }
    }

    private class EC2TagSubstitutor
    extends AbstractSubstitutor {
        private Map<String, String> cachedTags;

        public EC2TagSubstitutor() {
            super("{ec2:tag:");
        }

        @Override
        protected String retrieveValue(String name) {
            String value;
            if (name == null || name.isEmpty()) {
                return null;
            }
            if (this.cachedTags == null) {
                this.cachedTags = Collections.emptyMap();
                String instanceId = Substitutions.this.infoFacade().retrieveEC2InstanceId();
                if (instanceId != null) {
                    this.cachedTags = Substitutions.this.infoFacade().retrieveEC2Tags(instanceId);
                }
            }
            return (value = this.cachedTags.get(name)) != null ? value : "unknown";
        }
    }

    private class EC2RegionSubstitutor
    extends AbstractSubstitutor {
        public EC2RegionSubstitutor() {
            super("{ec2:region}");
        }

        @Override
        protected String retrieveValue(String ignored) {
            this.cachedValue = Substitutions.this.infoFacade().retrieveEC2Region();
            return this.cachedValue;
        }
    }

    private class EC2InstanceIdSubstitutor
    extends AbstractSubstitutor {
        public EC2InstanceIdSubstitutor() {
            super("{ec2:instanceId}", "{instanceId}");
        }

        @Override
        protected String retrieveValue(String ignored) {
            this.cachedValue = Substitutions.this.infoFacade().retrieveEC2InstanceId();
            return this.cachedValue;
        }
    }

    private class AwsAccountIdSubstitutor
    extends AbstractSubstitutor {
        public AwsAccountIdSubstitutor() {
            super("{aws:accountId}");
        }

        @Override
        protected String retrieveValue(String ignored) {
            this.cachedValue = Substitutions.this.infoFacade().retrieveAccountId();
            return this.cachedValue;
        }
    }

    private class EnvarSubstitutor
    extends AbstractSubstitutor {
        public EnvarSubstitutor() {
            super("{env:");
        }

        @Override
        protected String retrieveValue(String name) {
            if (name == null || name.isEmpty()) {
                return null;
            }
            return System.getenv(name);
        }
    }

    private class SyspropSubstitutor
    extends AbstractSubstitutor {
        public SyspropSubstitutor() {
            super("{sysprop:");
        }

        @Override
        protected String retrieveValue(String name) {
            if (name == null || name.isEmpty()) {
                return null;
            }
            return System.getProperty(name);
        }
    }

    private class UUIDSubstitutor
    extends AbstractSubstitutor {
        public UUIDSubstitutor() {
            super("{uuid}");
        }

        @Override
        protected String retrieveValue(String ignored) {
            return UUID.randomUUID().toString();
        }
    }

    private class HostnameSubstitutor
    extends AbstractSubstitutor {
        private RuntimeMXBean runtimeMx;

        public HostnameSubstitutor(RuntimeMXBean runtimeMx) {
            super("{hostname}");
            this.runtimeMx = runtimeMx;
        }

        @Override
        protected String retrieveValue(String ignored) {
            String vmName = this.runtimeMx.getName();
            this.cachedValue = vmName.indexOf(64) > 0 ? vmName.substring(vmName.indexOf(64) + 1) : "unknown";
            return this.cachedValue;
        }
    }

    private class PidSubstitutor
    extends AbstractSubstitutor {
        private RuntimeMXBean runtimeMx;

        public PidSubstitutor(RuntimeMXBean runtimeMx) {
            super("{pid}");
            this.runtimeMx = runtimeMx;
        }

        @Override
        protected String retrieveValue(String ignored) {
            String vmName = this.runtimeMx.getName();
            this.cachedValue = vmName.indexOf(64) > 0 ? vmName.substring(0, vmName.indexOf(64)) : "unknown";
            return this.cachedValue;
        }
    }

    private class StartupTimestampSubstitutor
    extends AbstractSubstitutor {
        private RuntimeMXBean runtimeMx;

        public StartupTimestampSubstitutor(RuntimeMXBean runtimeMx) {
            super("{startupTimestamp}");
            this.runtimeMx = runtimeMx;
        }

        @Override
        protected String retrieveValue(String ignored) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
            formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.cachedValue = formatter.format(new Date(this.runtimeMx.getStartTime()));
            return this.cachedValue;
        }
    }

    private class HourlyTimestampSubstitutor
    extends AbstractSubstitutor {
        private Date now;

        public HourlyTimestampSubstitutor(Date now) {
            super("{hourlyTimestamp}");
            this.now = now;
        }

        @Override
        protected String retrieveValue(String ignored) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHH'0000'");
            formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.cachedValue = formatter.format(this.now);
            return this.cachedValue;
        }
    }

    private class TimestampSubstitutor
    extends AbstractSubstitutor {
        private Date now;

        public TimestampSubstitutor(Date now) {
            super("{timestamp}");
            this.now = now;
        }

        @Override
        protected String retrieveValue(String ignored) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
            formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.cachedValue = formatter.format(this.now);
            return this.cachedValue;
        }
    }

    private class DateSubstitutor
    extends AbstractSubstitutor {
        private Date now;

        public DateSubstitutor(Date now) {
            super("{date}");
            this.now = now;
        }

        @Override
        protected String retrieveValue(String ignored) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
            formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.cachedValue = formatter.format(this.now);
            return this.cachedValue;
        }
    }

    private class SequenceSubstitutor
    extends AbstractSubstitutor {
        public SequenceSubstitutor(int sequence) {
            super("{sequence}");
            this.cachedValue = String.valueOf(sequence);
        }
    }

    private abstract class AbstractSubstitutor {
        private List<String> tags;
        protected String cachedValue;

        public AbstractSubstitutor(String ... tags) {
            this.tags = Arrays.asList(tags);
        }

        public String perform(String input) {
            if (input == null) {
                return "";
            }
            String result = null;
            Iterator<String> itx = this.tags.iterator();
            while (itx.hasNext() && result == null) {
                String tag = itx.next();
                if (input.equals(tag)) {
                    result = this.cachedValue != null ? this.cachedValue : this.retrieveValue(null);
                    continue;
                }
                if (!input.startsWith(tag)) continue;
                result = this.cachedValue != null ? this.cachedValue : this.trySubstitution(input, tag);
            }
            return result == null ? input : result;
        }

        private String trySubstitution(String input, String tag) {
            String result;
            String embeddedKey = input.replace(tag, "").replace("}", "");
            String defaultValue = "";
            int splitPoint = embeddedKey.indexOf(58);
            if (splitPoint >= 0) {
                defaultValue = embeddedKey.substring(splitPoint + 1);
                embeddedKey = embeddedKey.substring(0, splitPoint);
            }
            if ((result = this.retrieveValue(embeddedKey)) != null) {
                return result;
            }
            return defaultValue.isEmpty() ? null : defaultValue;
        }

        protected String retrieveValue(String embeddedKey) {
            return null;
        }
    }
}

